/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.file;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.DefaultFileRegion;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedFile;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.RandomAccessFile;

public class FileServerHandler
extends SimpleChannelInboundHandler<String> {
    public void channelActive(ChannelHandlerContext ctx) {
        ctx.writeAndFlush((Object)"HELO: Type the path of the file to retrieve.\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(ChannelHandlerContext ctx, String msg) throws Exception {
        RandomAccessFile raf = null;
        long length = -1L;
        try {
            raf = new RandomAccessFile(msg, "r");
            length = raf.length();
        }
        catch (Exception e) {
            ctx.writeAndFlush((Object)("ERR: " + e.getClass().getSimpleName() + ": " + e.getMessage() + '\n'));
            return;
        }
        finally {
            if (length < 0L && raf != null) {
                raf.close();
            }
        }
        ctx.write((Object)("OK: " + raf.length() + '\n'));
        if (ctx.pipeline().get(SslHandler.class) == null) {
            ctx.write((Object)new DefaultFileRegion(raf.getChannel(), 0L, length));
        } else {
            ctx.write((Object)new ChunkedFile(raf));
        }
        ctx.writeAndFlush((Object)"\n");
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        cause.printStackTrace();
        if (ctx.channel().isActive()) {
            ctx.writeAndFlush((Object)("ERR: " + cause.getClass().getSimpleName() + ": " + cause.getMessage() + '\n')).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }
}

