/*
 * Decompiled with CFR 0.152.
 */
package io.mvnpm.maven.locker.mojos;

import com.google.common.io.Resources;
import io.fabric8.maven.Maven;
import io.fabric8.maven.merge.SmartModelMerger;
import io.mvnpm.maven.locker.LockerProfile;
import io.mvnpm.maven.locker.model.Artifacts;
import io.mvnpm.maven.locker.model.GAV;
import io.mvnpm.maven.locker.model.ParentPom;
import io.mvnpm.maven.locker.mojos.AbstractDependencyLockMojo;
import io.mvnpm.maven.locker.mojos.LockerMode;
import io.mvnpm.maven.locker.pom.DefaultLockerPom;
import io.mvnpm.maven.locker.pom.LockerPom;
import io.mvnpm.maven.locker.pom.LockerPomFileAccessor;
import io.quarkus.qute.Qute;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.maven.model.Model;
import org.apache.maven.model.Profile;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="lock", requiresDependencyResolution=ResolutionScope.TEST)
public final class LockMojo
extends AbstractDependencyLockMojo {
    @Parameter(property="locker.filter", defaultValue="org.mvnpm*,org.webjars*")
    private List<String> filters;
    @Parameter(property="locker.mode")
    private LockerMode mode;

    public void execute() throws MojoExecutionException {
        boolean lockerBomModeEnabled;
        boolean alreadyConfiguredWithLockerBom;
        if (this.project.getActiveProfiles().stream().map(Profile::getId).anyMatch("locker"::equals)) {
            throw new MojoExecutionException("Locking is not possible with 'locker' profile enabled. Use '-Dunlocked' when locking or add the 'locker-maven-plugin' extension to '.mvn/extensions.xml'.");
        }
        LockerPomFileAccessor lockFile = this.lockFile();
        ParentPom parentPom = this.getParentPom(lockFile.file);
        Artifacts lockedDependencies = this.projectDependencies().filter(this.filters);
        boolean lockFileExists = lockFile.exists();
        Model model = this.project.getModel();
        Optional<Profile> existingLockerProfile = LockerProfile.findLockerProfile(model);
        boolean bl = alreadyConfiguredWithLockerBom = LockerProfile.usesLockerBom(existingLockerProfile) || lockFileExists;
        if (alreadyConfiguredWithLockerBom) {
            this.getLog().info((CharSequence)"Configured with locker BOM Mode");
            if (LockerMode.IN_PROFILE.equals((Object)this.mode)) {
                this.getLog().warn((CharSequence)"Ignoring 'locker.mode' parameter, the project is already configured with Locker BOM Mode");
            }
        }
        boolean bl2 = lockerBomModeEnabled = LockerMode.LOCKER_BOM.equals((Object)this.mode) || alreadyConfiguredWithLockerBom;
        if (existingLockerProfile.isEmpty() && this.mode == null) {
            lockerBomModeEnabled = true;
        }
        if (lockerBomModeEnabled) {
            this.getLog().info((CharSequence)String.format(Locale.ROOT, "%s %s", lockFileExists ? "Updating" : "Creating", lockFile.absolutePath()));
            LockerPom lockerPom = DefaultLockerPom.from(lockFile, this.pomMinimums(), this.getLog());
            lockerPom.write(parentPom, lockedDependencies);
        }
        boolean addLockerProfile = false;
        if (existingLockerProfile.isEmpty()) {
            if (lockerBomModeEnabled) {
                this.getLog().info((CharSequence)"Adding 'locker' profile with the Locker BOM to the pom.xml...");
            } else {
                this.getLog().info((CharSequence)("Adding 'locker' profile with " + lockedDependencies.artifacts.size() + " locked dependencies to the pom.xml..."));
            }
            addLockerProfile = true;
        } else {
            if (existingLockerProfile.get().getActivation().isActiveByDefault()) {
                this.getLog().info((CharSequence)"Switching to '!unlocked' property activation in 'locker' profile");
                addLockerProfile = true;
            }
            if (!lockerBomModeEnabled) {
                this.getLog().info((CharSequence)"Updating 'locker' profile with locked dependencies");
                addLockerProfile = true;
            } else if (!LockerProfile.usesLockerBom(existingLockerProfile)) {
                addLockerProfile = true;
                this.getLog().info((CharSequence)"Switching to locker BOM in 'locker' profile");
            }
        }
        Model newModel = model;
        if (addLockerProfile) {
            newModel = this.addProfileToPom(lockerBomModeEnabled ? null : lockedDependencies);
        } else {
            this.getLog().info((CharSequence)"No changes to the project pom.xml");
        }
        boolean hasActiveByDefaultProfiles = newModel.getProfiles().stream().anyMatch(p -> p.getActivation().isActiveByDefault());
        if (hasActiveByDefaultProfiles) {
            this.getLog().warn((CharSequence)"\n\nThe locker profile uses a negated property '!unlocked' for activation, this disables other profiles with 'activeByDefault'.\n\nYour pom.xml contains other profiles with 'activeByDefault=true'.\nConsider replacing 'activeByDefault=true' from your profiles by property activation (i.e use !foo to be active unless -Dfoo).\n\n");
        }
    }

    private ParentPom getParentPom(Path lockerPom) {
        String relativeParentPath;
        if (this.project.getParent() != null && (relativeParentPath = this.getRelativeParentPath(lockerPom)) != null) {
            return new ParentPom(GAV.from(this.project.getParent()), relativeParentPath);
        }
        return null;
    }

    public String getRelativeParentPath(Path lockerPom) {
        Path parentPath = this.project.getParent().getFile().toPath().toAbsolutePath();
        Path parentDirPath = parentPath.getParent();
        if (lockerPom.startsWith(parentDirPath)) {
            return lockerPom.getParent().relativize(parentPath).toString();
        }
        return null;
    }

    private Model addProfileToPom(Artifacts lockedDependencies) throws MojoExecutionException {
        Model locker;
        Model model = Maven.readModel((Path)this.project.getFile().toPath());
        try {
            String content = this.getLockerProfile(lockedDependencies);
            locker = Maven.readModel((Reader)new StringReader(content));
        }
        catch (IOException e) {
            throw new MojoExecutionException((Throwable)e);
        }
        SmartModelMerger merger = new SmartModelMerger();
        LockerProfile.findLockerProfile(model).ifPresent(arg_0 -> ((Model)model).removeProfile(arg_0));
        merger.merge(model, locker, false, Map.of());
        Maven.writeModel((Model)model);
        return model;
    }

    private String getLockerProfile(Artifacts lockedDependencies) throws IOException {
        String tpl = Resources.toString((URL)Resources.getResource(LockMojo.class, (String)"locker-profile.xml"), (Charset)StandardCharsets.UTF_8);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("lockedDependencies", lockedDependencies);
        data.put("useNegatedProp", true);
        data.put("lockerProfile", "locker");
        data.put("groupId", this.project.getGroupId());
        data.put("artifactId", this.project.getArtifactId());
        return Qute.fmt((String)tpl, data);
    }
}

