/*
 * Decompiled with CFR 0.152.
 */
package io.mvnpm.maven.locker.model;

import io.mvnpm.maven.locker.model.Artifact;
import io.mvnpm.maven.locker.model.ArtifactIdentifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class Artifacts
implements Iterable<Artifact> {
    public final List<Artifact> artifacts;

    private Artifacts(Collection<Artifact> artifacts) {
        ArrayList<Artifact> copy = new ArrayList<Artifact>(artifacts);
        Collections.sort(copy);
        this.artifacts = Collections.unmodifiableList(copy);
    }

    public static Artifacts fromMavenArtifacts(Collection<org.apache.maven.artifact.Artifact> artifacts) {
        return new Artifacts(artifacts.stream().map(a -> Artifact.from(a)).collect(Collectors.toList()));
    }

    public static Artifacts fromArtifacts(Collection<Artifact> artifacts) {
        return new Artifacts(artifacts);
    }

    public Optional<Artifact> find(ArtifactIdentifier identifier) {
        for (Artifact artifact : this.artifacts) {
            if (!identifier.equals(artifact.identifier)) continue;
            return Optional.of(artifact);
        }
        return Optional.empty();
    }

    public Artifacts filter(List<String> filters) {
        return Artifacts.fromArtifacts(this.artifacts.stream().filter((? super T a) -> Artifacts.isArtifactMatched(filters, a)).collect(Collectors.toList()));
    }

    private static boolean isArtifactMatched(List<String> filters, Artifact a) {
        return filters.stream().anyMatch(f -> {
            if (f == null || f.isBlank()) {
                return false;
            }
            String[] split = f.split(":");
            if (split.length > 2) {
                throw new IllegalArgumentException("Invalid artifact filter: " + f);
            }
            if (Artifacts.matchesWildcard(a.identifier.groupId, split[0])) {
                return true;
            }
            return split.length == 2 && Artifacts.matchesWildcard(a.identifier.artifactId, split[1]);
        });
    }

    static boolean matchesWildcard(String input, String wildcard) {
        CharSequence[] wildcardParts = wildcard.split("\\*");
        for (int i = 0; i < wildcardParts.length; ++i) {
            wildcardParts[i] = Pattern.quote((String)wildcardParts[i]);
        }
        Object regex = String.join((CharSequence)".*", wildcardParts);
        if (wildcard.startsWith("*")) {
            regex = ".*" + (String)regex;
        }
        if (wildcard.endsWith("*")) {
            regex = (String)regex + ".*";
        }
        regex = String.format("^%s$", regex);
        return Pattern.compile((String)regex).matcher(input).matches();
    }

    @Override
    public Iterator<Artifact> iterator() {
        return this.artifacts.iterator();
    }
}

