/*
 * Decompiled with CFR 0.152.
 */
package io.mvnpm.maven.locker.extensions;

import io.fabric8.maven.Maven;
import io.mvnpm.maven.locker.InstallLocker;
import io.mvnpm.maven.locker.LockerConstants;
import io.mvnpm.maven.locker.LockerProfile;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;
import org.apache.maven.model.Profile;
import org.codehaus.plexus.logging.Logger;

@Singleton
@Named(value="locker")
public class LockerExtension
extends AbstractMavenLifecycleParticipant {
    private final Logger logger;

    @Inject
    public LockerExtension(Logger logger) {
        this.logger = logger;
    }

    public void afterSessionStart(MavenSession session) throws MavenExecutionException {
        Path pomPath = session.getRequest().getPom().toPath();
        if (!Files.exists(pomPath, new LinkOption[0])) {
            return;
        }
        Path lockerPom = pomPath.getParent().resolve("locker/pom.xml");
        if (session.getGoals().stream().anyMatch(LockerConstants.LOCK_GOAL_PREDICATE)) {
            this.prepareForLocking(session);
        } else {
            this.prepareForBuilding(session, pomPath, lockerPom);
        }
    }

    private void prepareForBuilding(MavenSession session, Path pomPath, Path lockerPom) throws MavenExecutionException {
        Model model = Maven.readModel((Path)pomPath);
        Optional<Profile> lockerProfile = LockerProfile.findLockerProfile(model);
        if (Files.exists(lockerPom, new LinkOption[0])) {
            if (lockerProfile.isEmpty()) {
                this.logger.warn("'locker' profile not found in the pom.xml, remove the Locker BOM if it is not used.");
                return;
            }
            InstallLocker.installLocker(session.getLocalRepository(), lockerPom, this.logger);
        } else if (lockerProfile.isPresent() && LockerProfile.usesLockerBom(lockerProfile)) {
            throw new MavenExecutionException("'locker' profile found in the '" + pomPath + "' but corresponding Locker BOM not found in: " + lockerPom, session.getRequest().getPom());
        }
    }

    private void prepareForLocking(MavenSession session) throws MavenExecutionException {
        session.getRequest().getInactiveProfiles().add("locker");
    }
}

