/*
 * Decompiled with CFR 0.152.
 */
package io.mvnpm.maven.locker;

import com.google.common.hash.Hashing;
import io.fabric8.maven.Maven;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Model;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.codehaus.plexus.logging.Logger;

public final class InstallLocker {
    public static void installLocker(ArtifactRepository localRepository, Path lockerPom, Logger log) throws MavenExecutionException {
        try {
            Path lockerPomInRepo = InstallLocker.pathOfLockPomInLocalRepo(localRepository, lockerPom);
            if (Files.exists(lockerPomInRepo, new LinkOption[0])) {
                byte[] lockerHashRepo;
                byte[] lockerHash = Hashing.sha512().hashBytes(Files.readAllBytes(lockerPom)).asBytes();
                if (Arrays.equals(lockerHash, lockerHashRepo = Hashing.sha512().hashBytes(Files.readAllBytes(lockerPomInRepo)).asBytes())) {
                    log.info("Locker BOM is installed in Maven local repository and up-to-date.");
                    return;
                }
                log.info("Locker BOM is out-of-date in Maven local repository, installing...");
            } else {
                log.info("Locker BOM is not in Maven local repository, installing...");
            }
            DefaultInvocationRequest request = new DefaultInvocationRequest();
            request.setPomFile(lockerPom.toFile());
            request.setBatchMode(true);
            request.setGoals(Collections.singletonList("clean install"));
            request.setOutputHandler(arg_0 -> ((Logger)log).debug(arg_0));
            request.setErrorHandler(arg_0 -> ((Logger)log).error(arg_0));
            DefaultInvoker invoker = new DefaultInvoker();
            InvocationResult result = invoker.execute((InvocationRequest)request);
            if (result.getExitCode() != 0) {
                throw new MavenExecutionException("Error while installing Locker BOM.", lockerPom.toFile());
            }
            log.info("Locker BOM has been installed.");
        }
        catch (IOException | MavenInvocationException e) {
            throw new MavenExecutionException("Error while installing Locker BOM.", e);
        }
    }

    private static Path pathOfLockPomInLocalRepo(ArtifactRepository localRepository, Path lockerPom) {
        Model lockerModel = Maven.readModel((Path)lockerPom);
        String groupId = lockerModel.getGroupId();
        String version = lockerModel.getVersion();
        if (groupId == null && lockerModel.getParent() != null) {
            groupId = lockerModel.getParent().getGroupId();
        }
        if (version == null && lockerModel.getParent() != null) {
            version = lockerModel.getParent().getVersion();
        }
        DefaultArtifact lockerArtifact = new DefaultArtifact(groupId, lockerModel.getArtifactId(), version, "import", "pom", null, (ArtifactHandler)new DefaultArtifactHandler());
        return Path.of(localRepository.getBasedir(), localRepository.pathOf((Artifact)lockerArtifact) + ".pom");
    }
}

