/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.jsonrpc;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;

public class JsonRpcIdDeserializer
extends JsonDeserializer<Object> {
    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        ObjectCodec codec = jsonParser.getCodec();
        JsonNode jsonNode = (JsonNode)codec.readTree(jsonParser);
        if (jsonNode.isNumber()) {
            return jsonNode.asInt();
        }
        if (jsonNode.isTextual()) {
            return jsonNode.asText();
        }
        if (jsonNode.isNull()) {
            return null;
        }
        throw new IOException("A JSON-RPC ID according to the spec \"MUST contain a String, Number, or NULL value if included\". See \u00a74 of https://www.jsonrpc.org/specification.");
    }
}

