/*
 * Decompiled with CFR 0.152.
 */
package io.mockk.impl.recording;

import io.mockk.Invocation;
import io.mockk.InvocationMatcher;
import io.mockk.MockKGateway;
import io.mockk.impl.InternalPlatform;
import io.mockk.impl.Ref;
import io.mockk.impl.log.SafeToString;
import io.mockk.impl.stub.Stub;
import io.mockk.impl.stub.StubRepository;
import io.mockk.impl.verify.VerificationHelpers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\fH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\fH\u0016J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J&\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00160\u001dH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001e"}, d2={"Lio/mockk/impl/recording/CommonVerificationAcknowledger;", "Lio/mockk/MockKGateway$VerificationAcknowledger;", "stubRepo", "Lio/mockk/impl/stub/StubRepository;", "safeToString", "Lio/mockk/impl/log/SafeToString;", "(Lio/mockk/impl/stub/StubRepository;Lio/mockk/impl/log/SafeToString;)V", "getSafeToString", "()Lio/mockk/impl/log/SafeToString;", "getStubRepo", "()Lio/mockk/impl/stub/StubRepository;", "acknowledgeVerificationHelper", "", "stub", "Lio/mockk/impl/stub/Stub;", "acknowledgeVerified", "mock", "", "checkUnnecessaryStub", "checkUnnecessaryStubHelper", "markCallVerified", "invocation", "Lio/mockk/Invocation;", "reportNotVerified", "", "nTotal", "", "nVerified", "notVerified", "", "mockk"})
@SourceDebugExtension(value={"SMAP\nCommonVerificationAcknowledger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommonVerificationAcknowledger.kt\nio/mockk/impl/recording/CommonVerificationAcknowledger\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,83:1\n1869#2,2:84\n1869#2,2:86\n1563#2:88\n1634#2,3:89\n1563#2:92\n1634#2,3:93\n1573#2:103\n1604#2,4:104\n506#3,7:96\n*S KotlinDebug\n*F\n+ 1 CommonVerificationAcknowledger.kt\nio/mockk/impl/recording/CommonVerificationAcknowledger\n*L\n21#1:84,2\n30#1:86,2\n39#1:88\n39#1:89,3\n40#1:92\n40#1:93,3\n77#1:103\n77#1:104,4\n70#1:96,7\n*E\n"})
public final class CommonVerificationAcknowledger
implements MockKGateway.VerificationAcknowledger {
    @NotNull
    private final StubRepository stubRepo;
    @NotNull
    private final SafeToString safeToString;

    public CommonVerificationAcknowledger(@NotNull StubRepository stubRepo, @NotNull SafeToString safeToString2) {
        Intrinsics.checkNotNullParameter((Object)stubRepo, (String)"stubRepo");
        Intrinsics.checkNotNullParameter((Object)safeToString2, (String)"safeToString");
        this.stubRepo = stubRepo;
        this.safeToString = safeToString2;
    }

    @NotNull
    public final StubRepository getStubRepo() {
        return this.stubRepo;
    }

    @NotNull
    public final SafeToString getSafeToString() {
        return this.safeToString;
    }

    public void markCallVerified(@NotNull Invocation invocation2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)invocation2, (String)"invocation");
            Object object = invocation2.getStub();
            Stub stub = object instanceof Stub ? (Stub)object : null;
            if (stub == null) break block0;
            stub.markCallVerified(invocation2);
        }
    }

    public void acknowledgeVerified() {
        Iterable $this$forEach$iv = this.stubRepo.getAllStubs();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Stub it = (Stub)element$iv;
            boolean bl = false;
            this.acknowledgeVerificationHelper(it);
        }
    }

    public void acknowledgeVerified(@NotNull Object mock2) {
        Intrinsics.checkNotNullParameter((Object)mock2, (String)"mock");
        Stub stub = this.stubRepo.stubFor(mock2);
        this.acknowledgeVerificationHelper(stub);
    }

    public void checkUnnecessaryStub() {
        Iterable $this$forEach$iv = this.stubRepo.getAllStubs();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Stub it = (Stub)element$iv;
            boolean bl = false;
            this.checkUnnecessaryStubHelper(it);
        }
    }

    public void checkUnnecessaryStub(@NotNull Object mock2) {
        Intrinsics.checkNotNullParameter((Object)mock2, (String)"mock");
        Stub stub = this.stubRepo.stubFor(mock2);
        this.checkUnnecessaryStubHelper(stub);
    }

    /*
     * WARNING - void declaration
     */
    private final void acknowledgeVerificationHelper(Stub stub) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Iterable $this$map$iv = stub.allRecordedCalls();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            Invocation invocation2 = (Invocation)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(InternalPlatform.INSTANCE.ref(it));
        }
        HashSet allCalls = CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv));
        Iterable $this$map$iv2 = stub.verifiedCalls();
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Invocation bl = (Invocation)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(InternalPlatform.INSTANCE.ref(it));
        }
        HashSet verifiedCalls = CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv2));
        if (Intrinsics.areEqual((Object)allCalls, (Object)verifiedCalls)) {
            return;
        }
        String nonVerifiedReport2 = (String)this.safeToString.exec((Function0)new Function0<String>(this, (HashSet<Ref>)allCalls, (HashSet<Ref>)verifiedCalls, stub){
            final /* synthetic */ CommonVerificationAcknowledger this$0;
            final /* synthetic */ HashSet<Ref> $allCalls;
            final /* synthetic */ HashSet<Ref> $verifiedCalls;
            final /* synthetic */ Stub $stub;
            {
                this.this$0 = $receiver;
                this.$allCalls = $allCalls;
                this.$verifiedCalls = $verifiedCalls;
                this.$stub = $stub;
                super(0);
            }

            public final String invoke() {
                return CommonVerificationAcknowledger.access$reportNotVerified(this.this$0, this.$allCalls.size(), this.$verifiedCalls.size(), CollectionsKt.minus((Iterable)this.$stub.allRecordedCalls(), (Iterable)CollectionsKt.toSet((Iterable)this.$stub.verifiedCalls())));
            }
        });
        throw new AssertionError((Object)("Verification acknowledgment failed" + nonVerifiedReport2));
    }

    private final String reportNotVerified(int nTotal, int nVerified, List<Invocation> notVerified) {
        return "\n\nVerified call count: " + nVerified + "\nRecorded call count: " + nTotal + "\n\n\nNot verified calls:\n" + VerificationHelpers.formatCalls$default(VerificationHelpers.INSTANCE, notVerified, null, 2, null) + "\n\nStack traces:\n" + VerificationHelpers.INSTANCE.stackTraces(notVerified);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkUnnecessaryStubHelper(Stub stub) {
        void $this$mapIndexedTo$iv$iv;
        void $this$mapIndexed$iv;
        Map<InvocationMatcher, Integer> $this$filterValues$iv = stub.matcherUsages();
        boolean $i$f$filterValues22 = false;
        LinkedHashMap<InvocationMatcher, Integer> result$iv = new LinkedHashMap<InvocationMatcher, Integer>();
        for (Map.Entry<InvocationMatcher, Integer> entry$iv : $this$filterValues$iv.entrySet()) {
            int it = ((Number)entry$iv.getValue()).intValue();
            boolean bl = false;
            if (!(it == 0)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Set unnecessaryMatcher = ((Map)result$iv).keySet();
        if (unnecessaryMatcher.isEmpty()) {
            return;
        }
        Iterable $i$f$filterValues22 = unnecessaryMatcher;
        StringBuilder stringBuilder = new StringBuilder().append("Unnecessary stubbings detected.\nFollowing stubbings are not used, either because there are unnecessary or because tested code doesn't call them :\n\n");
        boolean $i$f$mapIndexed = false;
        Iterator<Map.Entry<InvocationMatcher, Integer>> iterator = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void matcher;
            void idx;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            InvocationMatcher invocationMatcher = (InvocationMatcher)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((int)(idx + true) + ") " + matcher);
        }
        String report = stringBuilder.append(CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null)).toString();
        throw new AssertionError((Object)report);
    }

    public static final /* synthetic */ String access$reportNotVerified(CommonVerificationAcknowledger $this, int nTotal, int nVerified, List notVerified) {
        return $this.reportNotVerified(nTotal, nVerified, notVerified);
    }
}

