/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.v2.service.resourcegroup;

import io.milvus.common.resourcegroup.NodeInfo;
import io.milvus.common.resourcegroup.ResourceGroupConfig;
import io.milvus.common.resourcegroup.ResourceGroupLimit;
import io.milvus.common.resourcegroup.ResourceGroupNodeFilter;
import io.milvus.common.resourcegroup.ResourceGroupTransfer;
import io.milvus.grpc.CreateResourceGroupRequest;
import io.milvus.grpc.DescribeResourceGroupRequest;
import io.milvus.grpc.DescribeResourceGroupResponse;
import io.milvus.grpc.DropResourceGroupRequest;
import io.milvus.grpc.ListResourceGroupsRequest;
import io.milvus.grpc.ListResourceGroupsResponse;
import io.milvus.grpc.MilvusServiceGrpc;
import io.milvus.grpc.ResourceGroup;
import io.milvus.grpc.ResourceGroupConfig;
import io.milvus.grpc.Status;
import io.milvus.grpc.TransferNodeRequest;
import io.milvus.grpc.TransferReplicaRequest;
import io.milvus.grpc.UpdateResourceGroupsRequest;
import io.milvus.v2.exception.ErrorCode;
import io.milvus.v2.exception.MilvusClientException;
import io.milvus.v2.service.BaseService;
import io.milvus.v2.service.resourcegroup.request.CreateResourceGroupReq;
import io.milvus.v2.service.resourcegroup.request.DescribeResourceGroupReq;
import io.milvus.v2.service.resourcegroup.request.DropResourceGroupReq;
import io.milvus.v2.service.resourcegroup.request.ListResourceGroupsReq;
import io.milvus.v2.service.resourcegroup.request.TransferNodeReq;
import io.milvus.v2.service.resourcegroup.request.TransferReplicaReq;
import io.milvus.v2.service.resourcegroup.request.UpdateResourceGroupsReq;
import io.milvus.v2.service.resourcegroup.response.DescribeResourceGroupResp;
import io.milvus.v2.service.resourcegroup.response.ListResourceGroupsResp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ResourceGroupService
extends BaseService {
    private static io.milvus.grpc.ResourceGroupConfig convertResourceGroupConfig(ResourceGroupConfig config) {
        if (config == null) {
            throw new MilvusClientException(ErrorCode.INVALID_PARAMS, "Invalid resource group config");
        }
        ResourceGroupConfig.Builder builder = io.milvus.grpc.ResourceGroupConfig.newBuilder();
        builder.setRequests(io.milvus.grpc.ResourceGroupLimit.newBuilder().setNodeNum(config.getRequests().getNodeNum())).build();
        builder.setLimits(io.milvus.grpc.ResourceGroupLimit.newBuilder().setNodeNum(config.getLimits().getNodeNum())).build();
        for (ResourceGroupTransfer groupFrom : config.getFrom()) {
            builder.addTransferFrom(io.milvus.grpc.ResourceGroupTransfer.newBuilder().setResourceGroup(groupFrom.getResourceGroupName())).build();
        }
        for (ResourceGroupTransfer groupTo : config.getTo()) {
            builder.addTransferTo(io.milvus.grpc.ResourceGroupTransfer.newBuilder().setResourceGroup(groupTo.getResourceGroupName())).build();
        }
        if (config.getNodeFilter() != null) {
            builder.setNodeFilter(config.getNodeFilter().toGRPC());
        }
        return builder.build();
    }

    private static ResourceGroupConfig convertResourceGroupConfig(io.milvus.grpc.ResourceGroupConfig config) {
        ArrayList<ResourceGroupTransfer> fromList = new ArrayList<ResourceGroupTransfer>();
        config.getTransferFromList().forEach(groupFrom -> fromList.add(new ResourceGroupTransfer(groupFrom.getResourceGroup())));
        ArrayList<ResourceGroupTransfer> toList = new ArrayList<ResourceGroupTransfer>();
        config.getTransferToList().forEach(groupTo -> toList.add(new ResourceGroupTransfer(groupTo.getResourceGroup())));
        return ResourceGroupConfig.newBuilder().withRequests(new ResourceGroupLimit(config.getRequests().getNodeNum())).withLimits(new ResourceGroupLimit(config.getLimits().getNodeNum())).withFrom(fromList).withTo(toList).withNodeFilter(new ResourceGroupNodeFilter(config.getNodeFilter())).build();
    }

    public Void createResourceGroup(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, CreateResourceGroupReq request) {
        String title = String.format("CreateResourceGroupReq groupName:%s", request.getGroupName());
        io.milvus.grpc.ResourceGroupConfig rpcConfig = ResourceGroupService.convertResourceGroupConfig(request.getConfig());
        CreateResourceGroupRequest rpcRequest = CreateResourceGroupRequest.newBuilder().setResourceGroup(request.getGroupName()).setConfig(rpcConfig).build();
        Status status = blockingStub.createResourceGroup(rpcRequest);
        this.rpcUtils.handleResponse(title, status);
        return null;
    }

    public Void updateResourceGroups(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, UpdateResourceGroupsReq request) {
        String title = "UpdateResourceGroupsReq";
        Map<String, ResourceGroupConfig> resourceGroups = request.getResourceGroups();
        if (resourceGroups.isEmpty()) {
            throw new MilvusClientException(ErrorCode.INVALID_PARAMS, "Resource group configurations cannot be empty");
        }
        UpdateResourceGroupsRequest.Builder requestBuilder = UpdateResourceGroupsRequest.newBuilder();
        resourceGroups.forEach((groupName, config) -> {
            io.milvus.grpc.ResourceGroupConfig rpcConfig = ResourceGroupService.convertResourceGroupConfig(config);
            requestBuilder.putResourceGroups((String)groupName, rpcConfig);
        });
        Status status = blockingStub.updateResourceGroups(requestBuilder.build());
        this.rpcUtils.handleResponse(title, status);
        return null;
    }

    public Void dropResourceGroup(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, DropResourceGroupReq request) {
        String title = String.format("DropResourceGroupReq groupName:%s", request.getGroupName());
        DropResourceGroupRequest rpcRequest = DropResourceGroupRequest.newBuilder().setResourceGroup(request.getGroupName()).build();
        Status status = blockingStub.dropResourceGroup(rpcRequest);
        this.rpcUtils.handleResponse(title, status);
        return null;
    }

    public ListResourceGroupsResp listResourceGroups(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, ListResourceGroupsReq request) {
        String title = "ListResourceGroupsReq";
        ListResourceGroupsResponse response = blockingStub.listResourceGroups(ListResourceGroupsRequest.newBuilder().build());
        this.rpcUtils.handleResponse(title, response.getStatus());
        return ((ListResourceGroupsResp.ListResourceGroupsRespBuilder)ListResourceGroupsResp.builder().groupNames((List<String>)response.getResourceGroupsList())).build();
    }

    public DescribeResourceGroupResp describeResourceGroup(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, DescribeResourceGroupReq request) {
        String title = String.format("DescribeResourceGroupReq groupName:%s", request.getGroupName());
        DescribeResourceGroupRequest rpcRequest = DescribeResourceGroupRequest.newBuilder().setResourceGroup(request.getGroupName()).build();
        DescribeResourceGroupResponse response = blockingStub.describeResourceGroup(rpcRequest);
        this.rpcUtils.handleResponse(title, response.getStatus());
        ResourceGroup rgroup = response.getResourceGroup();
        ArrayList<NodeInfo> nodes = new ArrayList<NodeInfo>();
        rgroup.getNodesList().forEach(node -> nodes.add((NodeInfo)((NodeInfo.NodeInfoBuilder)((NodeInfo.NodeInfoBuilder)((NodeInfo.NodeInfoBuilder)NodeInfo.builder().nodeId(node.getNodeId())).address(node.getAddress())).hostname(node.getHostname())).build()));
        return ((DescribeResourceGroupResp.DescribeResourceGroupRespBuilder)((DescribeResourceGroupResp.DescribeResourceGroupRespBuilder)((DescribeResourceGroupResp.DescribeResourceGroupRespBuilder)((DescribeResourceGroupResp.DescribeResourceGroupRespBuilder)((DescribeResourceGroupResp.DescribeResourceGroupRespBuilder)((DescribeResourceGroupResp.DescribeResourceGroupRespBuilder)((DescribeResourceGroupResp.DescribeResourceGroupRespBuilder)((DescribeResourceGroupResp.DescribeResourceGroupRespBuilder)DescribeResourceGroupResp.builder().groupName(rgroup.getName())).capacity(rgroup.getCapacity())).numberOfAvailableNode(rgroup.getNumAvailableNode())).numberOfLoadedReplica(rgroup.getNumLoadedReplicaMap())).numberOfOutgoingNode(rgroup.getNumOutgoingNodeMap())).numberOfIncomingNode(rgroup.getNumIncomingNodeMap())).config(ResourceGroupService.convertResourceGroupConfig(rgroup.getConfig()))).nodes(nodes)).build();
    }

    public Void transferNode(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, TransferNodeReq request) {
        if (StringUtils.isEmpty((CharSequence)request.getSourceGroupName())) {
            throw new MilvusClientException(ErrorCode.INVALID_PARAMS, "Invalid source group name");
        }
        if (StringUtils.isEmpty((CharSequence)request.getTargetGroupName())) {
            throw new MilvusClientException(ErrorCode.INVALID_PARAMS, "Invalid target group name");
        }
        String title = String.format("TransferNode %d nodes from %s to %s", request.getNumOfNodes(), request.getSourceGroupName(), request.getTargetGroupName());
        Status response = blockingStub.transferNode(TransferNodeRequest.newBuilder().setSourceResourceGroup(request.getSourceGroupName()).setTargetResourceGroup(request.getTargetGroupName()).setNumNode(request.getNumOfNodes()).build());
        this.rpcUtils.handleResponse(title, response);
        return null;
    }

    public Void transferReplica(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, TransferReplicaReq request) {
        if (StringUtils.isEmpty((CharSequence)request.getSourceGroupName())) {
            throw new MilvusClientException(ErrorCode.INVALID_PARAMS, "Invalid source group name");
        }
        if (StringUtils.isEmpty((CharSequence)request.getTargetGroupName())) {
            throw new MilvusClientException(ErrorCode.INVALID_PARAMS, "Invalid target group name");
        }
        if (StringUtils.isEmpty((CharSequence)request.getCollectionName())) {
            throw new MilvusClientException(ErrorCode.INVALID_PARAMS, "Invalid collection name");
        }
        String title = String.format("TransferReplicaReq sourceGroupName:%s targetGroupName:%s collectionName:%s", request.getSourceGroupName(), request.getTargetGroupName(), request.getCollectionName());
        TransferReplicaRequest.Builder requestBuilder = TransferReplicaRequest.newBuilder().setSourceResourceGroup(request.getSourceGroupName()).setTargetResourceGroup(request.getTargetGroupName()).setCollectionName(request.getCollectionName()).setNumReplica(request.getNumberOfReplicas());
        if (StringUtils.isNotEmpty((CharSequence)request.getDatabaseName())) {
            requestBuilder.setDbName(request.getDatabaseName());
        }
        Status status = blockingStub.transferReplica(requestBuilder.build());
        this.rpcUtils.handleResponse(title, status);
        return null;
    }
}

