/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.common.resourcegroup;

import io.milvus.common.resourcegroup.ResourceGroupLimit;
import io.milvus.common.resourcegroup.ResourceGroupNodeFilter;
import io.milvus.common.resourcegroup.ResourceGroupTransfer;
import io.milvus.grpc.ResourceGroupConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;

public class ResourceGroupConfig {
    private final ResourceGroupLimit requests;
    private final ResourceGroupLimit limits;
    private final List<ResourceGroupTransfer> from;
    private final List<ResourceGroupTransfer> to;
    private final ResourceGroupNodeFilter nodeFilter;

    private ResourceGroupConfig(Builder builder) {
        this.requests = builder.requests;
        this.limits = builder.limits;
        this.nodeFilter = builder.nodeFilter;
        this.from = null == builder.from ? new ArrayList<ResourceGroupTransfer>() : builder.from;
        this.to = null == builder.to ? new ArrayList<ResourceGroupTransfer>() : builder.to;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public ResourceGroupConfig(@NonNull io.milvus.grpc.ResourceGroupConfig grpcConfig) {
        if (grpcConfig == null) {
            throw new NullPointerException("grpcConfig is marked non-null but is null");
        }
        this.requests = new ResourceGroupLimit(grpcConfig.getRequests());
        this.limits = new ResourceGroupLimit(grpcConfig.getLimits());
        this.from = grpcConfig.getTransferFromList().stream().map(transfer -> new ResourceGroupTransfer((io.milvus.grpc.ResourceGroupTransfer)transfer)).collect(Collectors.toList());
        this.to = grpcConfig.getTransferToList().stream().map(transfer -> new ResourceGroupTransfer((io.milvus.grpc.ResourceGroupTransfer)transfer)).collect(Collectors.toList());
        this.nodeFilter = new ResourceGroupNodeFilter(grpcConfig.getNodeFilter());
    }

    @NonNull
    public io.milvus.grpc.ResourceGroupConfig toGRPC() {
        ResourceGroupConfig.Builder builder = io.milvus.grpc.ResourceGroupConfig.newBuilder().setRequests(io.milvus.grpc.ResourceGroupLimit.newBuilder().setNodeNum(this.requests.getNodeNum())).setLimits(io.milvus.grpc.ResourceGroupLimit.newBuilder().setNodeNum(this.limits.getNodeNum()));
        if (this.from != null) {
            for (ResourceGroupTransfer transfer : this.from) {
                builder.addTransferFrom(transfer.toGRPC());
            }
        }
        if (this.to != null) {
            for (ResourceGroupTransfer transfer : this.to) {
                builder.addTransferTo(transfer.toGRPC());
            }
        }
        if (this.nodeFilter != null) {
            builder.setNodeFilter(this.nodeFilter.toGRPC());
        }
        return builder.build();
    }

    public ResourceGroupLimit getRequests() {
        return this.requests;
    }

    public ResourceGroupLimit getLimits() {
        return this.limits;
    }

    public List<ResourceGroupTransfer> getFrom() {
        return this.from;
    }

    public List<ResourceGroupTransfer> getTo() {
        return this.to;
    }

    public ResourceGroupNodeFilter getNodeFilter() {
        return this.nodeFilter;
    }

    public static final class Builder {
        private ResourceGroupLimit requests;
        private ResourceGroupLimit limits;
        private List<ResourceGroupTransfer> from;
        private List<ResourceGroupTransfer> to;
        private ResourceGroupNodeFilter nodeFilter;

        private Builder() {
        }

        public Builder withRequests(@NonNull ResourceGroupLimit requests) {
            if (requests == null) {
                throw new NullPointerException("requests is marked non-null but is null");
            }
            this.requests = requests;
            return this;
        }

        public Builder withLimits(@NonNull ResourceGroupLimit limits) {
            if (limits == null) {
                throw new NullPointerException("limits is marked non-null but is null");
            }
            this.limits = limits;
            return this;
        }

        public Builder withFrom(@NonNull List<ResourceGroupTransfer> from) {
            if (from == null) {
                throw new NullPointerException("from is marked non-null but is null");
            }
            this.from = from;
            return this;
        }

        public Builder withTo(@NonNull List<ResourceGroupTransfer> to) {
            if (to == null) {
                throw new NullPointerException("to is marked non-null but is null");
            }
            this.to = to;
            return this;
        }

        public Builder withNodeFilter(@NonNull ResourceGroupNodeFilter nodeFilter) {
            if (nodeFilter == null) {
                throw new NullPointerException("nodeFilter is marked non-null but is null");
            }
            this.nodeFilter = nodeFilter;
            return this;
        }

        public ResourceGroupConfig build() {
            return new ResourceGroupConfig(this);
        }
    }
}

