/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.retry.annotation;

import io.micronaut.context.annotation.AliasFor;
import io.micronaut.retry.annotation.DefaultRetryPredicate;
import io.micronaut.retry.annotation.RetryPredicate;
import io.micronaut.retry.annotation.Retryable;
import jakarta.validation.constraints.Digits;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Documented
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD, ElementType.TYPE, ElementType.ANNOTATION_TYPE})
@Retryable
public @interface CircuitBreaker {
    public static final int MAX_RETRY_ATTEMPTS = 4;

    @AliasFor(annotation=Retryable.class, member="includes")
    public Class<? extends Throwable>[] includes() default {};

    @AliasFor(annotation=Retryable.class, member="excludes")
    public Class<? extends Throwable>[] excludes() default {};

    @Digits(integer=4, fraction=0)
    @AliasFor(annotation=Retryable.class, member="attempts")
    public @Digits(integer=4, fraction=0) String attempts() default "3";

    @AliasFor(annotation=Retryable.class, member="delay")
    public String delay() default "500ms";

    @Digits(integer=2, fraction=2)
    @AliasFor(annotation=Retryable.class, member="multiplier")
    public @Digits(integer=2, fraction=2) String multiplier() default "0";

    @AliasFor(annotation=Retryable.class, member="maxDelay")
    public String maxDelay() default "5s";

    public String reset() default "20s";

    @AliasFor(annotation=Retryable.class, member="predicate")
    public Class<? extends RetryPredicate> predicate() default DefaultRetryPredicate.class;

    public boolean throwWrappedException() default false;
}

