/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.management.endpoint.beans.impl;

import io.micronaut.context.Qualifier;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.management.endpoint.beans.BeanDefinitionData;
import io.micronaut.management.endpoint.beans.BeansEndpoint;
import jakarta.inject.Singleton;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@Singleton
@Requires(beans={BeansEndpoint.class})
public class DefaultBeanDefinitionData
implements BeanDefinitionData<Map<String, Object>> {
    DefaultBeanDefinitionData() {
    }

    @Override
    public Map<String, Object> getData(BeanDefinition<?> beanDefinition) {
        LinkedHashMap<String, Object> beanData = new LinkedHashMap<String, Object>(3);
        beanData.put("dependencies", this.getDependencies(beanDefinition));
        beanData.put("scope", this.getScope(beanDefinition));
        beanData.put("type", this.getType(beanDefinition));
        beanData.put("qualifier", this.getQualifier(beanDefinition));
        return beanData;
    }

    @Nullable
    protected String getQualifier(@NonNull BeanDefinition<?> beanDefinition) {
        Qualifier q = beanDefinition.getDeclaredQualifier();
        if (q != null) {
            return q.toString();
        }
        return null;
    }

    @NonNull
    protected List<String> getDependencies(@NonNull BeanDefinition<?> beanDefinition) {
        return beanDefinition.getRequiredComponents().stream().map(Class::getName).sorted().toList();
    }

    @Nullable
    protected String getScope(@NonNull BeanDefinition<?> beanDefinition) {
        return beanDefinition.getScopeName().orElse(null);
    }

    @NonNull
    protected String getType(@NonNull BeanDefinition<?> beanDefinition) {
        return beanDefinition.getBeanType().getName();
    }
}

