/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.qualifiers;

import io.micronaut.context.Qualifier;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationUtil;
import io.micronaut.core.annotation.Internal;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.BeanType;
import java.util.stream.Stream;

@Internal
final class NoneQualifier<T>
implements Qualifier<T> {
    public static final NoneQualifier INSTANCE = new NoneQualifier();

    private NoneQualifier() {
    }

    @Override
    public <B extends BeanType<T>> Stream<B> reduce(Class<T> beanType, Stream<B> candidates) {
        return candidates.filter(candidate -> {
            if (candidate instanceof BeanDefinition) {
                return ((BeanDefinition)candidate).getDeclaredQualifier() == null;
            }
            return !AnnotationUtil.hasDeclaredQualifierAnnotation((AnnotationMetadata)candidate.getAnnotationMetadata());
        });
    }

    public String toString() {
        return "None";
    }
}

