/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.reactive.execution;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.execution.ExecutionFlow;
import io.micronaut.core.execution.ImperativeExecutionFlow;
import io.micronaut.http.reactive.execution.ReactiveExecutionFlow;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Fuseable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

@Internal
final class ReactorExecutionFlowImpl
implements ReactiveExecutionFlow<Object> {
    private Mono<Object> value;

    <K> ReactorExecutionFlowImpl(Publisher<K> value) {
        Mono mono;
        if (value instanceof Flux) {
            Flux flux = (Flux)value;
            mono = flux.next();
        } else {
            mono = Mono.from(value);
        }
        this(mono);
    }

    <K> ReactorExecutionFlowImpl(Mono<K> value) {
        this.value = value;
    }

    public <R> ExecutionFlow<R> flatMap(Function<? super Object, ? extends ExecutionFlow<? extends R>> transformer) {
        this.value = this.value.flatMap(value -> ReactorExecutionFlowImpl.toMono((ExecutionFlow)transformer.apply(value)));
        return this;
    }

    public <R> ExecutionFlow<R> then(Supplier<? extends ExecutionFlow<? extends R>> supplier) {
        this.value = this.value.then(Mono.fromSupplier(supplier).flatMap(ReactorExecutionFlowImpl::toMono));
        return this;
    }

    public <R> ExecutionFlow<R> map(Function<? super Object, ? extends R> function) {
        this.value = this.value.map(function);
        return this;
    }

    public ExecutionFlow<Object> onErrorResume(Function<? super Throwable, ? extends ExecutionFlow<?>> fallback) {
        this.value = this.value.onErrorResume(throwable -> ReactorExecutionFlowImpl.toMono((ExecutionFlow)fallback.apply((Throwable)throwable)));
        return this;
    }

    public ExecutionFlow<Object> putInContext(String key, Object value) {
        this.value = this.value.contextWrite(context -> context.put((Object)key, value));
        return this;
    }

    public void onComplete(final BiConsumer<? super Object, Throwable> fn) {
        this.value.subscribe((CoreSubscriber)new CoreSubscriber<Object>(){
            Subscription subscription;
            Object value;

            public Context currentContext() {
                if (fn instanceof ReactiveConsumer) {
                    ReactiveConsumer reactiveConsumer = (ReactiveConsumer)fn;
                    return Context.of((ContextView)reactiveConsumer.contextView);
                }
                return super.currentContext();
            }

            public void onSubscribe(Subscription s) {
                this.subscription = s;
                s.request(1L);
            }

            public void onNext(Object v) {
                this.value = v;
                this.subscription.request(1L);
            }

            public void onError(Throwable t) {
                fn.accept(null, t);
            }

            public void onComplete() {
                fn.accept(this.value, null);
            }
        });
    }

    @Nullable
    public ImperativeExecutionFlow<Object> tryComplete() {
        Mono<Object> mono = this.value;
        if (mono instanceof Fuseable.ScalarCallable) {
            Fuseable.ScalarCallable callable = (Fuseable.ScalarCallable)mono;
            try {
                return (ImperativeExecutionFlow)ExecutionFlow.just((Object)callable.call());
            }
            catch (Exception e) {
                return (ImperativeExecutionFlow)ExecutionFlow.error((Throwable)e);
            }
        }
        return null;
    }

    static <R> Mono<Object> toMono(ExecutionFlow<R> next) {
        if (next instanceof ReactorExecutionFlowImpl) {
            ReactorExecutionFlowImpl reactiveFlowImpl = (ReactorExecutionFlowImpl)next;
            return reactiveFlowImpl.value;
        }
        if (next instanceof ImperativeExecutionFlow) {
            ImperativeExecutionFlow imperativeFlow = (ImperativeExecutionFlow)next;
            Mono m = imperativeFlow.getError() != null ? Mono.error((Throwable)imperativeFlow.getError()) : (imperativeFlow.getValue() != null ? Mono.just((Object)imperativeFlow.getValue()) : Mono.empty());
            Map context = imperativeFlow.getContext();
            if (!context.isEmpty()) {
                m = m.contextWrite(ctx -> {
                    for (Map.Entry e : context.entrySet()) {
                        ctx = ctx.put(e.getKey(), e.getValue());
                    }
                    return ctx;
                });
            }
            return m;
        }
        return Mono.deferContextual(contextView -> {
            final Sinks.One sink = Sinks.one();
            ReactiveConsumer reactiveConsumer = new ReactiveConsumer((ContextView)contextView){

                @Override
                public void accept(Object o, Throwable throwable) {
                    if (throwable != null) {
                        sink.tryEmitError(throwable);
                    } else {
                        sink.tryEmitValue(o);
                    }
                }
            };
            next.onComplete((BiConsumer)reactiveConsumer);
            return sink.asMono();
        });
    }

    static <R> Mono<Object> toMono(Supplier<ExecutionFlow<R>> next) {
        return Mono.defer(() -> ReactorExecutionFlowImpl.toMono((ExecutionFlow)next.get()));
    }

    @Override
    public Publisher<Object> toPublisher() {
        return this.value;
    }

    public CompletableFuture<Object> toCompletableFuture() {
        return this.value.toFuture();
    }

    private static abstract class ReactiveConsumer
    implements BiConsumer<Object, Throwable> {
        private final ContextView contextView;

        private ReactiveConsumer(ContextView contextView) {
            this.contextView = contextView;
        }
    }
}

