/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http;

import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpMessage;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpHeaders;
import io.micronaut.http.body.MessageBodyWriter;
import java.util.Base64;
import java.util.Map;
import java.util.function.Consumer;

public interface MutableHttpMessage<B>
extends HttpMessage<B> {
    default public MutableHttpMessage<B> bodyWriter(MessageBodyWriter<B> messageBodyWriter) {
        this.setAttribute(HttpAttributes.MESSAGE_BODY_WRITER, messageBodyWriter);
        return this;
    }

    @Override
    public MutableHttpHeaders getHeaders();

    public <T> MutableHttpMessage<T> body(T var1);

    default public MutableHttpMessage<B> headers(Consumer<MutableHttpHeaders> headers) {
        headers.accept(this.getHeaders());
        return this;
    }

    default public MutableHttpMessage<B> header(CharSequence name, CharSequence value) {
        this.getHeaders().add(name, value);
        return this;
    }

    default public MutableHttpMessage<B> basicAuth(CharSequence username, CharSequence password) {
        StringBuilder sb = new StringBuilder();
        sb.append(username);
        sb.append(":");
        sb.append(password);
        StringBuilder value = new StringBuilder();
        value.append("Basic");
        value.append(" ");
        value.append(new String(Base64.getEncoder().encode(sb.toString().getBytes())));
        this.header("Authorization", value.toString());
        return this;
    }

    default public MutableHttpMessage<B> bearerAuth(CharSequence token) {
        String sb = "Bearer " + token;
        this.header("Authorization", sb);
        return this;
    }

    default public MutableHttpMessage<B> headers(Map<CharSequence, CharSequence> namesAndValues) {
        MutableHttpHeaders headers = this.getHeaders();
        namesAndValues.forEach(headers::add);
        return this;
    }

    default public MutableHttpMessage<B> contentLength(long length) {
        this.getHeaders().set("Content-Length", String.valueOf(length));
        return this;
    }

    default public MutableHttpMessage<B> contentType(CharSequence contentType) {
        if (contentType == null) {
            this.getHeaders().remove("Content-Type");
        } else {
            this.getHeaders().set("Content-Type", contentType);
        }
        return this;
    }

    default public MutableHttpMessage<B> contentType(MediaType mediaType) {
        if (mediaType == null) {
            this.getHeaders().remove("Content-Type");
        } else {
            this.getHeaders().set("Content-Type", mediaType);
        }
        return this;
    }

    default public MutableHttpMessage<B> contentEncoding(CharSequence encoding) {
        if (encoding == null) {
            this.getHeaders().remove("Content-Encoding");
        } else {
            this.getHeaders().set("Content-Encoding", encoding);
        }
        return this;
    }
}

