/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.io.scan;

import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.core.io.ResourceLoader;
import io.micronaut.core.io.scan.DefaultClassPathResourceLoader;

public interface ClassPathResourceLoader
extends ResourceLoader {
    public ClassLoader getClassLoader();

    @Override
    default public boolean supportsPrefix(String path) {
        return path.startsWith("classpath:");
    }

    public static ClassPathResourceLoader defaultLoader(@Nullable ClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        if (classLoader == null) {
            classLoader = ClassPathResourceLoader.class.getClassLoader();
        }
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return new DefaultClassPathResourceLoader(classLoader);
    }
}

