/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.beans;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanIntrospector;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.beans.DefaultBeanWrapper;
import io.micronaut.core.beans.exceptions.IntrospectionException;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionError;
import io.micronaut.core.convert.exceptions.ConversionErrorException;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import java.util.Collection;
import java.util.Optional;

public interface BeanWrapper<T>
extends AnnotationMetadataProvider {
    @NonNull
    public BeanIntrospection<T> getIntrospection();

    @NonNull
    public T getBean();

    @NonNull
    default public String[] getPropertyNames() {
        return this.getIntrospection().getPropertyNames();
    }

    @NonNull
    default public Collection<BeanProperty<T, Object>> getBeanProperties() {
        return this.getIntrospection().getBeanProperties();
    }

    @NonNull
    default public <P> P getRequiredProperty(@NonNull String name, @NonNull Class<P> type) {
        ArgumentUtils.requireNonNull("name", name);
        ArgumentUtils.requireNonNull("type", type);
        Argument<P> argument = Argument.of(type);
        return this.getRequiredProperty(name, argument);
    }

    default public <P> P getRequiredProperty(@NonNull String name, @NonNull Argument<P> argument) {
        ArgumentUtils.requireNonNull("name", name);
        ArgumentUtils.requireNonNull("argument", argument);
        ArgumentConversionContext<P> context = ConversionContext.of(argument);
        return this.getRequiredProperty(name, context);
    }

    @NonNull
    default public <P> P getRequiredProperty(@NonNull String name, @NonNull ArgumentConversionContext<P> context) {
        ArgumentUtils.requireNonNull("name", name);
        ArgumentUtils.requireNonNull("type", context);
        return (P)this.getIntrospection().getProperty(name).map(prop -> {
            Optional converted = prop.get(this.getBean(), context);
            return converted.orElseThrow(() -> {
                ConversionError conversionError = context.getLastError().orElseGet(() -> new ConversionError((BeanProperty)prop, context){
                    final /* synthetic */ BeanProperty val$prop;
                    final /* synthetic */ ArgumentConversionContext val$context;
                    {
                        this.val$prop = beanProperty;
                        this.val$context = argumentConversionContext;
                    }

                    @Override
                    public Exception getCause() {
                        return new IntrospectionException("Property of type [" + this.val$prop.getType() + "] cannot be converted to type: " + this.val$context.getArgument().getType());
                    }

                    @Override
                    public Optional<Object> getOriginalValue() {
                        return Optional.ofNullable(this.val$prop.get(BeanWrapper.this.getBean()));
                    }
                });
                return new ConversionErrorException(context.getArgument(), conversionError);
            });
        }).orElseThrow(() -> new IntrospectionException("No property found for name: " + name));
    }

    @NonNull
    default public <P> Optional<P> getProperty(@NonNull String name, @NonNull Class<P> type) {
        ArgumentUtils.requireNonNull("name", name);
        ArgumentUtils.requireNonNull("type", type);
        Argument<P> argument = Argument.of(type);
        return this.getProperty(name, argument);
    }

    default public <P> Optional<P> getProperty(@NonNull String name, Argument<P> type) {
        ArgumentUtils.requireNonNull("name", name);
        ArgumentUtils.requireNonNull("type", type);
        ArgumentConversionContext<P> context = ConversionContext.of(type);
        return this.getProperty(name, context);
    }

    default public <P> Optional<P> getProperty(@NonNull String name, ArgumentConversionContext<P> context) {
        ArgumentUtils.requireNonNull("name", name);
        ArgumentUtils.requireNonNull("context", context);
        return this.getIntrospection().getProperty(name).flatMap(prop -> prop.get(this.getBean(), context));
    }

    default public BeanWrapper<T> setProperty(@NonNull String name, @Nullable Object value) {
        ArgumentUtils.requireNonNull("name", name);
        this.getIntrospection().getProperty(name).ifPresent(prop -> prop.convertAndSet(this.getBean(), value));
        return this;
    }

    @NonNull
    public static <T2> BeanWrapper<T2> getWrapper(@NonNull T2 bean) {
        ArgumentUtils.requireNonNull("bean", bean);
        Class<?> aClass = bean.getClass();
        BeanIntrospection<?> introspection = BeanIntrospection.getIntrospection(aClass);
        return new DefaultBeanWrapper<T2>(bean, introspection);
    }

    @NonNull
    public static <T2> Optional<BeanWrapper<T2>> findWrapper(@NonNull T2 bean) {
        ArgumentUtils.requireNonNull("bean", bean);
        Class<?> aClass = bean.getClass();
        return BeanIntrospector.SHARED.findIntrospection(aClass).map(i -> new DefaultBeanWrapper<Object>(bean, (BeanIntrospection<Object>)i));
    }

    @NonNull
    public static <T2> Optional<BeanWrapper<T2>> findWrapper(Class<T2> type, @NonNull T2 bean) {
        ArgumentUtils.requireNonNull("type", type);
        ArgumentUtils.requireNonNull("bean", bean);
        return BeanIntrospector.SHARED.findIntrospection(type).map(i -> new DefaultBeanWrapper<Object>(bean, (BeanIntrospection<Object>)i));
    }

    @NonNull
    public static <T2> BeanWrapper<T2> getWrapper(Class<T2> type, @NonNull T2 bean) {
        ArgumentUtils.requireNonNull("type", type);
        ArgumentUtils.requireNonNull("bean", bean);
        BeanIntrospection<T2> introspection = BeanIntrospection.getIntrospection(type);
        return new DefaultBeanWrapper<T2>(bean, introspection);
    }
}

