/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.metrics.micrometer.intercept;

import io.micrometer.core.annotation.Counted;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micronaut.aop.InterceptedMethod;
import io.micronaut.aop.InterceptorBean;
import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.configuration.metrics.annotation.RequiresMetrics;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.util.StringUtils;
import jakarta.inject.Inject;
import java.util.concurrent.CompletionStage;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RequiresMetrics
@InterceptorBean(value={Counted.class})
public class CountedInterceptor
implements MethodInterceptor<Object, Object> {
    public static final String DEFAULT_METRIC_NAME = "method.counted";
    public static final String RESULT_TAG = "result";
    private final MeterRegistry meterRegistry;
    private final ConversionService conversionService;

    @Deprecated
    public CountedInterceptor(MeterRegistry meterRegistry) {
        this(meterRegistry, ConversionService.SHARED);
    }

    @Inject
    public CountedInterceptor(MeterRegistry meterRegistry, ConversionService conversionService) {
        this.meterRegistry = meterRegistry;
        this.conversionService = conversionService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object intercept(MethodInvocationContext<Object, Object> context) {
        AnnotationMetadata metadata = context.getAnnotationMetadata();
        String metricName = metadata.stringValue(Counted.class).orElse(DEFAULT_METRIC_NAME);
        if (!StringUtils.isNotEmpty((CharSequence)metricName)) return context.proceed();
        InterceptedMethod interceptedMethod = InterceptedMethod.of(context, (ConversionService)this.conversionService);
        try {
            InterceptedMethod.ResultType resultType = interceptedMethod.resultType();
            switch (resultType) {
                case PUBLISHER: {
                    Mono reactiveResult;
                    Object interceptResult = context.proceed();
                    if (interceptResult == null) {
                        return null;
                    }
                    if (context.getReturnType().isSingleResult()) {
                        Mono single = Mono.from((Publisher)((Publisher)Publishers.convertPublisher((ConversionService)this.conversionService, (Object)interceptResult, Publisher.class)));
                        reactiveResult = single.doOnError(throwable -> this.doCount(metadata, metricName, (Throwable)throwable)).doOnSuccess(o -> this.doCount(metadata, metricName, null));
                        return Publishers.convertPublisher((ConversionService)this.conversionService, (Object)reactiveResult, (Class)context.getReturnType().getType());
                    }
                    Flux flowable = Flux.from((Publisher)((Publisher)Publishers.convertPublisher((ConversionService)this.conversionService, (Object)interceptResult, Publisher.class)));
                    reactiveResult = flowable.doOnError(throwable -> this.doCount(metadata, metricName, (Throwable)throwable)).doOnComplete(() -> this.doCount(metadata, metricName, null));
                    return Publishers.convertPublisher((ConversionService)this.conversionService, (Object)reactiveResult, (Class)context.getReturnType().getType());
                }
                case COMPLETION_STAGE: {
                    CompletionStage completionStage = interceptedMethod.interceptResultAsCompletionStage();
                    CompletionStage<Object> completionStageResult = completionStage.whenComplete((o, throwable) -> this.doCount(metadata, metricName, (Throwable)throwable));
                    return interceptedMethod.handleResult(completionStageResult);
                }
                case SYNCHRONOUS: {
                    Object result = context.proceed();
                    try {
                        Object object = result;
                        return object;
                    }
                    finally {
                        if (metadata.isFalse(Counted.class, "recordFailuresOnly")) {
                            this.doCount(metadata, metricName, null);
                        }
                    }
                }
            }
            return interceptedMethod.unsupported();
        }
        catch (Exception e) {
            try {
                Object object = interceptedMethod.handleException(e);
                return object;
            }
            finally {
                this.doCount(metadata, metricName, e);
            }
        }
    }

    private void doCount(AnnotationMetadata metadata, String metricName, @Nullable Throwable e) {
        Counter.builder((String)metricName).tags(metadata.stringValues(Counted.class, "extraTags")).description((String)metadata.stringValue(Counted.class, "description").orElse(null)).tag("exception", e != null ? e.getClass().getSimpleName() : "none").tag(RESULT_TAG, e != null ? "failure" : "success").register(this.meterRegistry).increment();
    }
}

