/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.metrics.micrometer;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import io.micronaut.configuration.metrics.aggregator.CompositeMeterRegistryConfigurer;
import io.micronaut.configuration.metrics.aggregator.MeterRegistryConfigurer;
import io.micronaut.configuration.metrics.annotation.RequiresMetrics;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Primary;
import io.micronaut.core.annotation.TypeHint;
import io.micronaut.core.util.CollectionUtils;
import jakarta.inject.Singleton;
import java.util.Collection;
import java.util.List;

@Factory
@TypeHint(value={MeterRegistry.class})
public class MeterRegistryFactory {
    public static final String MICRONAUT_METRICS = "micronaut.metrics.";
    public static final String MICRONAUT_METRICS_BINDERS = "micronaut.metrics.binders";
    public static final String MICRONAUT_METRICS_COMMON_TAGS = "micronaut.metrics.tags";
    public static final String MICRONAUT_METRICS_ENABLED = "micronaut.metrics.enabled";
    public static final String MICRONAUT_METRICS_EXPORT = "micronaut.metrics.export";

    @Primary
    @Singleton
    @Bean(preDestroy="close")
    CompositeMeterRegistry compositeMeterRegistry(List<MeterRegistry> registries, List<MeterRegistryConfigurer<MeterRegistry>> configurers) {
        if (CollectionUtils.isEmpty(registries)) {
            registries.add((MeterRegistry)new SimpleMeterRegistry());
        }
        CompositeMeterRegistry compositeMeterRegistry = new CompositeMeterRegistry();
        for (MeterRegistry registry : registries) {
            compositeMeterRegistry.add(registry);
            for (MeterRegistryConfigurer<MeterRegistry> configurer : configurers) {
                if (configurer.getType().isAssignableFrom(CompositeMeterRegistry.class) && configurer.supports((MeterRegistry)compositeMeterRegistry)) {
                    configurer.configure((MeterRegistry)compositeMeterRegistry);
                }
                if (!configurer.getType().isAssignableFrom(registry.getClass()) || !configurer.supports(registry)) continue;
                configurer.configure(registry);
            }
        }
        return compositeMeterRegistry;
    }

    @Primary
    @Singleton
    @RequiresMetrics
    MeterRegistryConfigurer<CompositeMeterRegistry> meterRegistryConfigurer(Collection<MeterBinder> binders, Collection<MeterFilter> filters) {
        return new CompositeMeterRegistryConfigurer(binders, filters);
    }
}

