/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.metrics.management.endpoint;

import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Statistic;
import io.micrometer.core.instrument.Tag;
import io.micronaut.configuration.metrics.annotation.RequiresMetrics;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.annotation.TypeHint;
import io.micronaut.core.bind.exceptions.UnsatisfiedArgumentException;
import io.micronaut.core.type.Argument;
import io.micronaut.management.endpoint.annotation.Endpoint;
import io.micronaut.management.endpoint.annotation.Read;
import io.micronaut.management.endpoint.annotation.Selector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.sql.DataSource;

@Endpoint(value="metrics", defaultSensitive=false)
@RequiresMetrics
@TypeHint(value={MetricsEndpoint.class, MetricNames.class, MetricDetails.class, AvailableTag.class, Sample.class}, accessType={TypeHint.AccessType.ALL_DECLARED_CONSTRUCTORS, TypeHint.AccessType.ALL_PUBLIC_METHODS})
public class MetricsEndpoint {
    static final boolean DEFAULT_SENSITIVE = false;
    static final String NAME = "metrics";
    private final MeterRegistry meterRegistry;

    public MetricsEndpoint(MeterRegistry meterRegistry, DataSource[] dataSources) {
        this.meterRegistry = meterRegistry;
    }

    @Read
    public MetricNames listNames() {
        return new MetricNames(this.meterRegistry.getMeters().stream().map(this::getName).collect(TreeSet::new, TreeSet::add, TreeSet::addAll));
    }

    @Read
    public MetricDetails getMetricDetails(@Selector String name, @Nullable List<String> tag) {
        return this.getMetricDetailsResponse(name, tag);
    }

    private MetricDetails getMetricDetailsResponse(String name, List<String> tagNames) {
        List<Tag> tags = tagNames == null ? Collections.emptyList() : tagNames.stream().map(s -> {
            String[] tv;
            if (s.contains(":") && (tv = s.split(":")).length == 2) {
                return Tag.of((String)tv[0], (String)tv[1]);
            }
            throw new UnsatisfiedArgumentException(Argument.of(List.class, (String)"tags"), "Tags must be in the form key:value");
        }).collect(Collectors.toList());
        Collection meters = this.meterRegistry.find(name).tags(tags).meters();
        if (meters.isEmpty()) {
            return null;
        }
        Map<Statistic, Double> samples = this.getSamples(meters);
        Map<String, Set<String>> availableTags = this.getAvailableTags(meters);
        for (Tag t : tags) {
            availableTags.remove(t.getKey());
        }
        Meter.Id meterId = ((Meter)meters.iterator().next()).getId();
        return new MetricDetails(name, this.asList(samples, Sample::new), this.asList(availableTags, AvailableTag::new), meterId.getDescription(), meterId.getBaseUnit());
    }

    private Map<Statistic, Double> getSamples(Collection<Meter> meters) {
        LinkedHashMap<Statistic, Double> samples = new LinkedHashMap<Statistic, Double>();
        for (Meter meter : meters) {
            this.mergeMeasurements(samples, meter);
        }
        return samples;
    }

    private void mergeMeasurements(Map<Statistic, Double> samples, Meter meter) {
        for (Measurement measurement : meter.measure()) {
            samples.merge(measurement.getStatistic(), measurement.getValue(), this.mergeFunction(measurement.getStatistic()));
        }
    }

    private BiFunction<Double, Double, Double> mergeFunction(Statistic statistic) {
        return Statistic.MAX.equals((Object)statistic) ? Double::max : Double::sum;
    }

    private Map<String, Set<String>> getAvailableTags(Collection<Meter> meters) {
        HashMap<String, Set<String>> availableTags = new HashMap<String, Set<String>>();
        for (Meter meter : meters) {
            this.mergeAvailableTags(availableTags, meter);
        }
        return availableTags;
    }

    private void mergeAvailableTags(Map<String, Set<String>> availableTags, Meter meter) {
        for (Tag tag : meter.getId().getTags()) {
            Set<String> value = Collections.singleton(tag.getValue());
            availableTags.merge(tag.getKey(), value, this::merge);
        }
    }

    private <T> Set<T> merge(Set<T> set1, Set<T> set2) {
        HashSet<T> result = new HashSet<T>(set1.size() + set2.size());
        result.addAll(set1);
        result.addAll(set2);
        return result;
    }

    private <K, V, T> List<T> asList(Map<K, V> map, BiFunction<K, V, T> mapper) {
        return map.entrySet().stream().map(entry -> mapper.apply(entry.getKey(), entry.getValue())).collect(Collectors.toCollection(ArrayList::new));
    }

    private String getName(Meter meter) {
        return meter.getId().getName();
    }

    @Introspected
    public static final class MetricNames {
        private final SortedSet<String> names;

        MetricNames(SortedSet<String> names) {
            this.names = names;
        }

        public SortedSet<String> getNames() {
            return this.names;
        }
    }

    @Introspected
    public static final class MetricDetails {
        private final String name;
        private final List<Sample> measurements;
        private final List<AvailableTag> availableTags;
        private final String description;
        private final String baseUnit;

        MetricDetails(String name, List<Sample> measurements, List<AvailableTag> availableTags, String description, String baseUnit) {
            this.name = name;
            this.measurements = measurements;
            this.availableTags = availableTags;
            this.description = description;
            this.baseUnit = baseUnit;
        }

        public String getName() {
            return this.name;
        }

        public List<Sample> getMeasurements() {
            return this.measurements;
        }

        public List<AvailableTag> getAvailableTags() {
            return this.availableTags;
        }

        public String getDescription() {
            return this.description;
        }

        public String getBaseUnit() {
            return this.baseUnit;
        }
    }

    @Introspected
    public static final class Sample {
        private final Statistic statistic;
        private final Double value;

        Sample(Statistic statistic, Double value) {
            this.statistic = statistic;
            this.value = value;
        }

        public Statistic getStatistic() {
            return this.statistic;
        }

        public Double getValue() {
            return this.value;
        }

        public String toString() {
            return "MeasurementSample{statistic=" + this.statistic + ", value=" + this.value + "}";
        }
    }

    @Introspected
    public static final class AvailableTag {
        private final String tag;
        private final Set<String> values;

        AvailableTag(String tag, Set<String> values) {
            this.tag = tag;
            this.values = values;
        }

        public String getTag() {
            return this.tag;
        }

        public Set<String> getValues() {
            return this.values;
        }
    }
}

