/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.metrics.binder.web;

import io.micrometer.core.instrument.MeterRegistry;
import io.micronaut.configuration.metrics.annotation.RequiresMetrics;
import io.micronaut.configuration.metrics.binder.web.WebMetricsPublisher;
import io.micronaut.configuration.metrics.binder.web.WebMetricsServerCondition;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.filter.HttpServerFilter;
import io.micronaut.http.filter.ServerFilterChain;
import io.micronaut.http.uri.UriMatchTemplate;
import io.micronaut.web.router.UriRouteInfo;
import io.micronaut.web.router.UriRouteMatch;
import java.util.Optional;
import org.reactivestreams.Publisher;

@Filter(value={"${micronaut.metrics.http.path:/**}"})
@RequiresMetrics
@Requirements(value={@Requires(property="micronaut.metrics.binders.web.enabled", notEquals="false"), @Requires(condition=WebMetricsServerCondition.class)})
public class ServerRequestMeterRegistryFilter
implements HttpServerFilter {
    private static final String ATTRIBUTE_KEY = "micronaut.filter." + ServerRequestMeterRegistryFilter.class.getSimpleName();
    private static final String UNMATCHED_URI = "UNMATCHED_URI";
    private final MeterRegistry meterRegistry;

    public ServerRequestMeterRegistryFilter(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    private String resolvePath(HttpRequest<?> request) {
        Optional<String> routeInfo = request.getAttribute((CharSequence)HttpAttributes.ROUTE_INFO, UriRouteMatch.class).map(UriRouteMatch::getRouteInfo).map(UriRouteInfo::getUriMatchTemplate).map(UriMatchTemplate::toPathString);
        return routeInfo.orElseGet(() -> request.getAttribute((CharSequence)HttpAttributes.URI_TEMPLATE, String.class).orElse(UNMATCHED_URI));
    }

    public Publisher<MutableHttpResponse<?>> doFilter(HttpRequest<?> request, ServerFilterChain chain) {
        long start = System.nanoTime();
        Publisher responsePublisher = chain.proceed(request);
        String path = this.resolvePath(request);
        Optional attribute = request.getAttribute((CharSequence)ATTRIBUTE_KEY, Boolean.class);
        boolean reportErrors = attribute.isPresent();
        if (!attribute.isPresent()) {
            request.setAttribute((CharSequence)ATTRIBUTE_KEY, (Object)true);
        }
        return new WebMetricsPublisher(responsePublisher, this.meterRegistry, path, start, request.getMethod().toString(), reportErrors);
    }
}

