/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.metrics.binder.web;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micronaut.configuration.metrics.annotation.RequiresMetrics;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.annotation.Value;
import io.micronaut.core.util.ArrayUtils;
import jakarta.inject.Singleton;

@Factory
@RequiresMetrics
@Requires(property="micronaut.metrics.binders.web.enabled", notEquals="false")
public class HttpMeterFilterFactory {
    @Bean
    @Singleton
    @Requires(property="micronaut.metrics.binders.web.server.percentiles")
    MeterFilter addServerPercentileMeterFilter(@Value(value="${micronaut.metrics.binders.web.server.percentiles}") Double[] percentiles) {
        return this.getMeterFilter(percentiles, "http.server.requests");
    }

    @Bean
    @Singleton
    @Requires(property="micronaut.metrics.binders.web.client.percentiles")
    MeterFilter addClientPercentileMeterFilter(@Value(value="${micronaut.metrics.binders.web.client.percentiles}") Double[] percentiles) {
        return this.getMeterFilter(percentiles, "http.client.requests");
    }

    private MeterFilter getMeterFilter(final Double[] percentiles, final String metricNamePrefix) {
        return new MeterFilter(){

            public DistributionStatisticConfig configure(Meter.Id id, DistributionStatisticConfig config) {
                if (id.getName().startsWith(metricNamePrefix)) {
                    return DistributionStatisticConfig.builder().percentiles((double[])ArrayUtils.toPrimitiveArray((Object[])percentiles)).build().merge(config);
                }
                return config;
            }
        };
    }
}

