/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.metrics.binder.web;

import io.micrometer.core.instrument.MeterRegistry;
import io.micronaut.configuration.metrics.annotation.RequiresMetrics;
import io.micronaut.configuration.metrics.binder.web.WebMetricsClientCondition;
import io.micronaut.configuration.metrics.binder.web.WebMetricsPublisher;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.filter.ClientFilterChain;
import io.micronaut.http.filter.HttpClientFilter;
import java.util.Optional;
import org.reactivestreams.Publisher;

@Filter(value={"${micronaut.metrics.http.client.path:/**}"})
@RequiresMetrics
@Requirements(value={@Requires(property="micronaut.metrics.binders.web.enabled", notEquals="false"), @Requires(condition=WebMetricsClientCondition.class)})
public class ClientRequestMetricRegistryFilter
implements HttpClientFilter {
    private static final String HOST_HEADER = "host";
    private final MeterRegistry meterRegistry;

    public ClientRequestMetricRegistryFilter(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    public Publisher<? extends HttpResponse<?>> doFilter(MutableHttpRequest<?> request, ClientFilterChain chain) {
        long start = System.nanoTime();
        Publisher responsePublisher = chain.proceed(request);
        return new WebMetricsPublisher(responsePublisher, this.meterRegistry, this.resolvePath(request), start, request.getMethod().toString(), false, this.resolveServiceID(request), true);
    }

    private String resolvePath(MutableHttpRequest<?> request) {
        Optional route = request.getAttribute((CharSequence)HttpAttributes.URI_TEMPLATE, String.class);
        return route.orElse(null);
    }

    private String resolveServiceID(MutableHttpRequest<?> request) {
        String serviceId = request.getAttributes().get((CharSequence)HttpAttributes.SERVICE_ID.toString(), String.class).orElse(null);
        if (StringUtils.isNotEmpty((CharSequence)serviceId) && serviceId.charAt(0) == '/') {
            return "embedded-server";
        }
        return serviceId;
    }
}

