/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.metrics.binder.retry;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micronaut.configuration.metrics.annotation.RequiresMetrics;
import io.micronaut.context.BeanProvider;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.retry.event.RetryEvent;
import io.micronaut.retry.event.RetryEventListener;
import jakarta.inject.Singleton;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Requirements(value={@Requires(classes={RetryEventListener.class, RetryEvent.class}), @Requires(property="micronaut.metrics.binders.retry.enabled", notEquals="false", defaultValue="false")})
@Singleton
@RequiresMetrics
public class RetryMetricsBinder
implements RetryEventListener {
    public static final String RETRY_METRICS_ENABLED = "micronaut.metrics.binders.retry.enabled";
    private static final Logger LOGGER = LoggerFactory.getLogger(RetryMetricsBinder.class);
    private final BeanProvider<MeterRegistry> meterRegistryProvider;
    private final HashMap<ExecutableMethod<?, ?>, Counter> attemptCounters = new HashMap();

    public RetryMetricsBinder(BeanProvider<MeterRegistry> meterRegistryProvider) {
        this.meterRegistryProvider = meterRegistryProvider;
    }

    public void onApplicationEvent(RetryEvent event) {
        if (!this.meterRegistryProvider.isPresent()) {
            LOGGER.debug("meter registry not present in provider, ignoring retry event");
            return;
        }
        ExecutableMethod executableMethod = event.getSource().getExecutableMethod();
        Counter retryCounter = this.attemptCounters.computeIfAbsent(executableMethod, method -> {
            String description = method.getDescription(true);
            MeterRegistry meterRegistry = (MeterRegistry)this.meterRegistryProvider.get();
            String declaringTypeName = method.getDeclaringType().getName();
            return meterRegistry.counter("micronaut.retry.attempt.total", new String[]{"method_description", description, "declaring_type", declaringTypeName});
        });
        retryCounter.increment();
    }
}

