/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.metrics.binder.netty;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import io.micronaut.configuration.metrics.annotation.RequiresMetrics;
import io.micronaut.configuration.metrics.binder.netty.MonitoredQueue;
import io.micronaut.configuration.metrics.binder.netty.NettyMetrics;
import io.micronaut.context.BeanProvider;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.http.server.netty.NettyHttpServer;
import io.netty.channel.EventLoopTaskQueueFactory;
import io.netty.util.internal.PlatformDependent;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;

@Singleton
@Named(value="InstrumentedEventLoopTaskQueueFactory")
@RequiresMetrics
@Requirements(value={@Requires(property="micronaut.metrics.binders.netty.queues.enabled", defaultValue="false", notEquals="false"), @Requires(classes={EventLoopTaskQueueFactory.class})})
@Internal
final class InstrumentedEventLoopTaskQueueFactory
implements EventLoopTaskQueueFactory {
    private static final AtomicInteger PARENT_COUNTER = new AtomicInteger(-1);
    private static final AtomicInteger WORKER_COUNTER = new AtomicInteger(-1);
    private final BeanProvider<MeterRegistry> meterRegistryProvider;
    private final Counter parentTaskCounter;
    private final Counter workerTaskCounter;
    private final Timer globalParentWaitTimeTimer;
    private final Timer globalParentExecutionTimer;
    private final Timer globalWorkerWaitTimeTimer;
    private final Timer globalWorkerExecutionTimer;

    public InstrumentedEventLoopTaskQueueFactory(BeanProvider<MeterRegistry> meterRegistryProvider) {
        this.meterRegistryProvider = meterRegistryProvider;
        this.globalParentWaitTimeTimer = Timer.builder((String)NettyMetrics.dot("netty", "queue", "global", "wait.time")).description("Global wait time spent in the parent Queues.").tag("group", "parent").publishPercentileHistogram().register((MeterRegistry)meterRegistryProvider.get());
        this.globalParentExecutionTimer = Timer.builder((String)NettyMetrics.dot("netty", "queue", "global", "execution.time")).description("Global parent runnable execution time.").tag("group", "parent").publishPercentileHistogram().register((MeterRegistry)meterRegistryProvider.get());
        this.globalWorkerWaitTimeTimer = Timer.builder((String)NettyMetrics.dot("netty", "queue", "global", "wait.time")).description("Global wait time spent in the worker Queues.").tag("group", "worker").publishPercentileHistogram().register((MeterRegistry)meterRegistryProvider.get());
        this.globalWorkerExecutionTimer = Timer.builder((String)NettyMetrics.dot("netty", "queue", "global", "execution.time")).description("Global worker runnable execution time.").tag("group", "worker").publishPercentileHistogram().register((MeterRegistry)meterRegistryProvider.get());
        this.parentTaskCounter = Counter.builder((String)NettyMetrics.dot("netty", "queue", "global", "element", "count")).tag("group", "parent").register((MeterRegistry)meterRegistryProvider.get());
        this.workerTaskCounter = Counter.builder((String)NettyMetrics.dot("netty", "queue", "global", "element", "count")).tag("group", "worker").register((MeterRegistry)meterRegistryProvider.get());
    }

    public Queue<Runnable> newTaskQueue(int maxCapacity) {
        String kind = this.findOrigin();
        boolean parent = "parent".equals(kind);
        return new MonitoredQueue(parent ? PARENT_COUNTER.incrementAndGet() : WORKER_COUNTER.incrementAndGet(), (MeterRegistry)this.meterRegistryProvider.get(), Tag.of((String)"group", (String)kind), parent ? this.parentTaskCounter : this.workerTaskCounter, parent ? this.globalParentWaitTimeTimer : this.globalWorkerWaitTimeTimer, parent ? this.globalParentExecutionTimer : this.globalWorkerExecutionTimer, maxCapacity == Integer.MAX_VALUE ? PlatformDependent.newMpscQueue() : PlatformDependent.newMpscQueue((int)maxCapacity));
    }

    private String findOrigin() {
        for (StackTraceElement elt : Thread.currentThread().getStackTrace()) {
            if (NettyHttpServer.class.getName().equals(elt.getClassName()) && "createWorkerEventLoopGroup".equals(elt.getMethodName())) {
                return "worker";
            }
            if (!NettyHttpServer.class.getName().equals(elt.getClassName()) || !"createParentEventLoopGroup".equals(elt.getMethodName())) continue;
            return "parent";
        }
        return "worker";
    }
}

