/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.metrics.binder.netty;

import io.micronaut.configuration.metrics.annotation.RequiresMetrics;
import io.micronaut.configuration.metrics.binder.netty.InstrumentedEventLoopTaskQueueFactory;
import io.micronaut.context.annotation.Replaces;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.netty.channel.EpollAvailabilityCondition;
import io.micronaut.http.netty.channel.EpollEventLoopGroupFactory;
import io.micronaut.http.netty.channel.EventLoopGroupConfiguration;
import io.micronaut.http.netty.channel.EventLoopGroupFactory;
import io.netty.channel.DefaultSelectStrategyFactory;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.EventLoopTaskQueueFactory;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.util.concurrent.DefaultEventExecutorChooserFactory;
import io.netty.util.concurrent.EventExecutorChooserFactory;
import io.netty.util.concurrent.RejectedExecutionHandlers;
import io.netty.util.concurrent.ThreadPerTaskExecutor;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;

@Singleton
@Internal
@Replaces(bean=EpollEventLoopGroupFactory.class, named="native")
@Named(value="native")
@Requirements(value={@Requires(classes={Epoll.class}, condition=EpollAvailabilityCondition.class), @Requires(property="micronaut.metrics.binders.netty.queues.enabled", defaultValue="false", notEquals="false")})
@RequiresMetrics
final class InstrumentedEpollEventLoopGroupFactory
implements EventLoopGroupFactory {
    private final InstrumentedEventLoopTaskQueueFactory instrumentedEventLoopTaskQueueFactory;

    public InstrumentedEpollEventLoopGroupFactory(InstrumentedEventLoopTaskQueueFactory factory) {
        this.instrumentedEventLoopTaskQueueFactory = factory;
    }

    public EventLoopGroup createEventLoopGroup(int threads, @Nullable Integer ioRatio) {
        return new EpollEventLoopGroup(threads, null, (EventExecutorChooserFactory)DefaultEventExecutorChooserFactory.INSTANCE, DefaultSelectStrategyFactory.INSTANCE, RejectedExecutionHandlers.reject(), (EventLoopTaskQueueFactory)this.instrumentedEventLoopTaskQueueFactory);
    }

    public EventLoopGroup createEventLoopGroup(int threads, ThreadFactory threadFactory, @Nullable Integer ioRatio) {
        return new EpollEventLoopGroup(threads, (Executor)(threadFactory == null ? null : new ThreadPerTaskExecutor(threadFactory)), (EventExecutorChooserFactory)DefaultEventExecutorChooserFactory.INSTANCE, DefaultSelectStrategyFactory.INSTANCE, RejectedExecutionHandlers.reject(), (EventLoopTaskQueueFactory)this.instrumentedEventLoopTaskQueueFactory);
    }

    public EventLoopGroup createEventLoopGroup(int threads, Executor executor, @Nullable Integer ioRatio) {
        return new EpollEventLoopGroup(threads, executor, (EventExecutorChooserFactory)DefaultEventExecutorChooserFactory.INSTANCE, DefaultSelectStrategyFactory.INSTANCE, RejectedExecutionHandlers.reject(), (EventLoopTaskQueueFactory)this.instrumentedEventLoopTaskQueueFactory);
    }

    public Class<? extends ServerSocketChannel> serverSocketChannelClass() {
        return EpollServerSocketChannel.class;
    }

    @NonNull
    public Class<? extends SocketChannel> clientSocketChannelClass(@Nullable EventLoopGroupConfiguration configuration) {
        return EpollSocketChannel.class;
    }

    public boolean isNative() {
        return true;
    }
}

