/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.metrics.binder.datasource;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.jdbc.metadata.DataSourcePoolMetadata;
import java.util.function.Function;
import javax.sql.DataSource;

public class DataSourcePoolMetricsBinder
implements MeterBinder {
    private final DataSource dataSource;
    private final DataSourcePoolMetadata metadataProvider;
    private final Iterable<Tag> tags;

    DataSourcePoolMetricsBinder(DataSource dataSource, DataSourcePoolMetadata metadataProvider, String dataSourceName, Iterable<Tag> tags) {
        this.dataSource = dataSource;
        this.metadataProvider = metadataProvider;
        this.tags = Tags.concat(tags, (String[])new String[]{"name", dataSourceName});
    }

    public void bindTo(@NonNull MeterRegistry meterRegistry) {
        if (this.metadataProvider != null) {
            this.bindPoolMetadata(meterRegistry, "active", DataSourcePoolMetadata::getActive);
            this.bindPoolMetadata(meterRegistry, "max", DataSourcePoolMetadata::getMax);
            this.bindPoolMetadata(meterRegistry, "min", DataSourcePoolMetadata::getMin);
            this.bindPoolMetadata(meterRegistry, "usage", DataSourcePoolMetadata::getUsage);
        }
    }

    private <N extends Number> void bindPoolMetadata(MeterRegistry registry, String metricName, Function<DataSourcePoolMetadata, N> function) {
        this.bindDataSource(registry, metricName, this.getValueFunction(function));
    }

    private <N extends Number> Function<DataSource, N> getValueFunction(Function<DataSourcePoolMetadata, N> function) {
        return dataSource -> (Number)function.apply(this.metadataProvider);
    }

    private <N extends Number> void bindDataSource(MeterRegistry meterRegistry, String metricName, Function<DataSource, N> function) {
        if (function.apply(this.dataSource) != null) {
            meterRegistry.gauge("jdbc.connections." + metricName, this.tags, (Object)this.dataSource, m -> ((Number)function.apply((DataSource)m)).doubleValue());
        }
    }
}

