/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aws.sdk.v2.service.s3;

import io.micronaut.aws.sdk.v2.service.AWSServiceConfiguration;
import io.micronaut.aws.sdk.v2.service.AwsClientFactory;
import io.micronaut.aws.sdk.v2.service.s3.S3ConfigurationProperties;
import io.micronaut.aws.ua.UserAgentProvider;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Nullable;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.net.URI;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProviderChain;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.regions.providers.AwsRegionProviderChain;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3AsyncClientBuilder;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.S3Configuration;

@Factory
public class S3ClientFactory
extends AwsClientFactory<S3ClientBuilder, S3AsyncClientBuilder, S3Client, S3AsyncClient> {
    private final S3ConfigurationProperties configuration;

    @Deprecated
    public S3ClientFactory(AwsCredentialsProviderChain credentialsProvider, AwsRegionProviderChain regionProvider, S3ConfigurationProperties configuration) {
        this(credentialsProvider, regionProvider, configuration, null, null);
    }

    @Deprecated
    public S3ClientFactory(AwsCredentialsProviderChain credentialsProvider, AwsRegionProviderChain regionProvider, S3ConfigurationProperties configuration, @Nullable UserAgentProvider userAgentProvider) {
        this(credentialsProvider, regionProvider, configuration, userAgentProvider, null);
    }

    @Inject
    public S3ClientFactory(AwsCredentialsProviderChain credentialsProvider, AwsRegionProviderChain regionProvider, S3ConfigurationProperties configuration, @Nullable UserAgentProvider userAgentProvider, @Nullable @Named(value="s3") AWSServiceConfiguration awsServiceConfiguration) {
        super(credentialsProvider, regionProvider, userAgentProvider, awsServiceConfiguration != null ? awsServiceConfiguration : S3ClientFactory.createAWSServiceConfiguration(configuration));
        this.configuration = configuration;
    }

    private static AWSServiceConfiguration createAWSServiceConfiguration(final S3ConfigurationProperties s3ConfigurationProperties) {
        return new AWSServiceConfiguration(){

            @Override
            public URI getEndpointOverride() {
                return s3ConfigurationProperties.getEndpointOverride();
            }

            @Override
            public String getServiceName() {
                return "s3";
            }
        };
    }

    @Override
    protected S3ClientBuilder createSyncBuilder() {
        S3ClientBuilder builder = S3Client.builder();
        if (this.configuration.getEndpointOverride() != null) {
            builder.endpointOverride(this.configuration.getEndpointOverride());
        }
        builder.serviceConfiguration((S3Configuration)this.configuration.getBuilder().build());
        return builder;
    }

    @Override
    protected S3AsyncClientBuilder createAsyncBuilder() {
        S3AsyncClientBuilder builder = S3AsyncClient.builder();
        if (this.configuration.getEndpointOverride() != null) {
            builder.endpointOverride(this.configuration.getEndpointOverride());
        }
        builder.serviceConfiguration((S3Configuration)this.configuration.getBuilder().build());
        return builder;
    }

    @Override
    @Singleton
    public S3ClientBuilder syncBuilder(SdkHttpClient httpClient) {
        return (S3ClientBuilder)super.syncBuilder(httpClient);
    }

    @Override
    @Bean(preDestroy="close")
    @Singleton
    public S3Client syncClient(S3ClientBuilder builder) {
        return (S3Client)super.syncClient(builder);
    }

    @Override
    @Singleton
    @Requires(beans={SdkAsyncHttpClient.class})
    public S3AsyncClientBuilder asyncBuilder(SdkAsyncHttpClient httpClient) {
        return (S3AsyncClientBuilder)super.asyncBuilder(httpClient);
    }

    @Override
    @Bean(preDestroy="close")
    @Singleton
    @Requires(beans={SdkAsyncHttpClient.class})
    public S3AsyncClient asyncClient(S3AsyncClientBuilder builder) {
        return (S3AsyncClient)super.asyncClient(builder);
    }
}

