/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aot.core.codegen;

import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Modifier;

public class MapGenerator {
    private int methodCount = 0;

    public final CodeBlock generateMap(TypeSpec.Builder builder, Map<String, Object> values) {
        CodeBlock.Builder mapBuilder = CodeBlock.builder();
        mapBuilder.add("new $T() {{\n", new Object[]{HashMap.class});
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            mapBuilder.add("$L", new Object[]{CodeBlock.of((String)"put($S, $L)", (Object[])new Object[]{key, this.convertValueToSource(value, builder)})});
            mapBuilder.add(";\n", new Object[0]);
        }
        mapBuilder.add("}}", new Object[0]);
        return mapBuilder.build();
    }

    private String convertValueToSource(Object value, TypeSpec.Builder builder) {
        if (value == null) {
            return "null";
        }
        Class<?> valueClass = value.getClass();
        if (CharSequence.class.isAssignableFrom(valueClass)) {
            return CodeBlock.of((String)"$S", (Object[])new Object[]{value}).toString();
        }
        if (Number.class.isAssignableFrom(valueClass) || Boolean.class.isAssignableFrom(valueClass)) {
            return this.convertNumberOrBoolean(valueClass, value);
        }
        if (List.class.isAssignableFrom(valueClass)) {
            return this.generateListMethod((List)value, builder);
        }
        if (Map.class.isAssignableFrom(valueClass)) {
            return this.generateMapMethod((Map)value, builder);
        }
        throw new UnsupportedOperationException("Configuration map contains an entry of type " + valueClass + " which is not supported yet. Please file a bug report.");
    }

    private String convertNumberOrBoolean(Class<?> valueClass, Object value) {
        String format = String.valueOf(value);
        String prefix = "";
        String appendix = "";
        if (Long.class.equals(valueClass)) {
            appendix = "L";
        } else if (Double.class.equals(valueClass)) {
            appendix = "D";
        } else if (Float.class.equals(valueClass)) {
            appendix = "F";
        } else if (Byte.class.equals(valueClass)) {
            prefix = "(byte) ";
        } else if (Short.class.equals(valueClass)) {
            prefix = "(short) ";
        }
        return prefix + format + appendix;
    }

    private String generateListMethod(List<?> value, TypeSpec.Builder builder) {
        String methodName = "list" + this.methodCount++;
        MethodSpec.Builder listMethod = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).returns(List.class);
        if (value.isEmpty()) {
            listMethod.addStatement("return $T.emptyList()", new Object[]{Collections.class});
        } else if (value.size() == 1) {
            listMethod.addStatement("return $T.singletonList($L)", new Object[]{Collections.class, this.convertValueToSource(value.get(0), builder)});
        } else {
            listMethod.addStatement("$T result = new $T<>($L)", new Object[]{List.class, ArrayList.class, value.size()});
            for (Object o : value) {
                listMethod.addStatement("result.add(" + this.convertValueToSource(o, builder) + ")", new Object[0]);
            }
            listMethod.addStatement("return result", new Object[0]);
        }
        builder.addMethod(listMethod.build());
        return methodName + "()";
    }

    private String generateMapMethod(Map<?, ?> value, TypeSpec.Builder builder) {
        String methodName = "map" + this.methodCount++;
        MethodSpec.Builder mapMethod = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).returns(Map.class);
        if (value.isEmpty()) {
            mapMethod.addStatement("return $.emptyMap()", new Object[]{Collections.class});
        } else if (value.size() == 1) {
            Map.Entry<?, ?> entry = value.entrySet().iterator().next();
            mapMethod.addStatement("return $T.singletonMap($L, $L)", new Object[]{Collections.class, this.convertValueToSource(entry.getKey(), builder), this.convertValueToSource(entry.getValue(), builder)});
        } else {
            mapMethod.addStatement("$T result = new $T<>($L)", new Object[]{Map.class, LinkedHashMap.class, value.size()});
            for (Map.Entry<?, ?> entry : value.entrySet()) {
                mapMethod.addStatement("result.put(" + this.convertValueToSource(entry.getKey(), builder) + ", " + this.convertValueToSource(entry.getValue(), builder) + ")", new Object[0]);
            }
            mapMethod.addStatement("return result", new Object[0]);
        }
        builder.addMethod(mapMethod.build());
        return methodName + "()";
    }
}

