/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.brave.bridge;

import brave.internal.propagation.StringPropagationAdapter;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import io.micrometer.common.lang.Nullable;
import io.micrometer.common.util.StringUtils;
import io.micrometer.common.util.internal.logging.InternalLogger;
import io.micrometer.common.util.internal.logging.InternalLoggerFactory;
import io.micrometer.tracing.Baggage;
import io.micrometer.tracing.BaggageManager;
import io.micrometer.tracing.brave.bridge.BraveTraceContext;
import io.micrometer.tracing.brave.bridge.TemporaryBuffers;
import io.micrometer.tracing.brave.bridge.TraceFlags;
import io.micrometer.tracing.brave.bridge.W3CBaggagePropagator;
import io.micrometer.tracing.internal.EncodingUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class W3CPropagation
extends Propagation.Factory
implements Propagation<String> {
    static final String TRACEPARENT = "traceparent";
    static final String TRACESTATE = "tracestate";
    private static final InternalLogger logger = InternalLoggerFactory.getInstance((String)W3CPropagation.class.getName());
    private static final List<String> FIELDS = Collections.unmodifiableList(Arrays.asList("traceparent", "tracestate"));
    private static final String VERSION = "00";
    private static final int VERSION_SIZE = 2;
    private static final char TRACEPARENT_DELIMITER = '-';
    private static final int TRACEPARENT_DELIMITER_SIZE = 1;
    private static final int LONG_BYTES = 8;
    private static final int BYTE_BASE16 = 2;
    private static final int LONG_BASE16 = 16;
    private static final int TRACE_ID_HEX_SIZE = 32;
    private static final int SPAN_ID_SIZE = 8;
    private static final int SPAN_ID_HEX_SIZE = 16;
    private static final int FLAGS_SIZE = 1;
    private static final int TRACE_OPTION_HEX_SIZE = 2;
    private static final int TRACE_ID_OFFSET = 3;
    private static final int SPAN_ID_OFFSET = 36;
    private static final int TRACE_OPTION_OFFSET = 53;
    private static final int TRACEPARENT_HEADER_SIZE = 55;
    private static final String INVALID_TRACE_ID = "00000000000000000000000000000000";
    private static final String INVALID_SPAN_ID = "0000000000000000";
    private static final Set<String> VALID_VERSIONS = new HashSet<String>();
    private static final String VERSION_00 = "00";
    @Nullable
    private final W3CBaggagePropagator baggagePropagator;
    @Nullable
    private final BaggageManager braveBaggageManager;

    public W3CPropagation(BaggageManager baggageManager, List<String> localFields) {
        this.baggagePropagator = new W3CBaggagePropagator(baggageManager, localFields);
        this.braveBaggageManager = baggageManager;
    }

    public W3CPropagation() {
        this.baggagePropagator = null;
        this.braveBaggageManager = null;
    }

    private static boolean isTraceIdValid(CharSequence traceId) {
        return traceId.length() == 32 && !INVALID_TRACE_ID.contentEquals(traceId) && EncodingUtils.isValidBase16String((CharSequence)traceId);
    }

    private static boolean isSpanIdValid(String spanId) {
        return spanId.length() == 16 && !INVALID_SPAN_ID.equals(spanId) && EncodingUtils.isValidBase16String((CharSequence)spanId);
    }

    private static TraceContext extractContextFromTraceParent(String traceparent) {
        boolean isValid;
        boolean bl = isValid = (traceparent.length() == 55 || traceparent.length() > 55 && traceparent.charAt(55) == '-') && traceparent.charAt(2) == '-' && traceparent.charAt(35) == '-' && traceparent.charAt(52) == '-';
        if (!isValid) {
            logger.info("Unparseable traceparent header. Returning INVALID span context.");
            return null;
        }
        try {
            String version = traceparent.substring(0, 2);
            if (!VALID_VERSIONS.contains(version)) {
                return null;
            }
            if (version.equals("00") && traceparent.length() > 55) {
                return null;
            }
            String traceId = traceparent.substring(3, 35);
            String spanId = traceparent.substring(36, 52);
            if (W3CPropagation.isTraceIdValid(traceId) && W3CPropagation.isSpanIdValid(spanId)) {
                String traceIdHigh = traceId.substring(0, traceId.length() / 2);
                String traceIdLow = traceId.substring(traceId.length() / 2);
                byte isSampled = TraceFlags.byteFromHex(traceparent, 53);
                return TraceContext.newBuilder().traceIdHigh(EncodingUtils.longFromBase16String((CharSequence)traceIdHigh)).traceId(EncodingUtils.longFromBase16String((CharSequence)traceIdLow)).spanId(EncodingUtils.longFromBase16String((CharSequence)spanId)).sampled(isSampled == 1).build();
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            logger.info("Unparseable traceparent header. Returning INVALID span context.");
            return null;
        }
    }

    public <K> Propagation<K> create(Propagation.KeyFactory<K> keyFactory) {
        return StringPropagationAdapter.create((Propagation)this, keyFactory);
    }

    public Propagation<String> get() {
        return this;
    }

    public List<String> keys() {
        return FIELDS;
    }

    public <R> TraceContext.Injector<R> injector(Propagation.Setter<R, String> setter) {
        return (context, carrier) -> {
            Objects.requireNonNull(context, "context");
            Objects.requireNonNull(setter, "setter");
            char[] chars = TemporaryBuffers.chars(55);
            chars[0] = "00".charAt(0);
            chars[1] = "00".charAt(1);
            chars[2] = 45;
            String traceId = this.padLeftWithZeros(context.traceIdString(), 32);
            for (int i = 0; i < traceId.length(); ++i) {
                chars[3 + i] = traceId.charAt(i);
            }
            chars[35] = 45;
            String spanId = context.spanIdString();
            for (int i = 0; i < spanId.length(); ++i) {
                chars[36 + i] = spanId.charAt(i);
            }
            chars[52] = 45;
            this.copyTraceFlagsHexTo(chars, 53, context);
            setter.put(carrier, (Object)TRACEPARENT, new String(chars, 0, 55));
            this.addTraceState(setter, context, carrier);
            if (this.baggagePropagator != null) {
                this.baggagePropagator.injector(setter).inject(context, carrier);
            }
        };
    }

    private <R> void addTraceState(Propagation.Setter<R, String> setter, TraceContext context, R carrier) {
        if (carrier != null && this.braveBaggageManager != null) {
            Baggage baggage = this.braveBaggageManager.getBaggage(BraveTraceContext.fromBrave(context), TRACESTATE);
            if (baggage == null) {
                return;
            }
            String traceState = baggage.get(BraveTraceContext.fromBrave(context));
            if (StringUtils.isNotBlank((String)traceState)) {
                setter.put(carrier, (Object)TRACESTATE, traceState);
            }
        }
    }

    private String padLeftWithZeros(String string, int length) {
        if (string.length() >= length) {
            return string;
        }
        StringBuilder sb = new StringBuilder(length);
        for (int i = string.length(); i < length; ++i) {
            sb.append('0');
        }
        return sb.append(string).toString();
    }

    void copyTraceFlagsHexTo(char[] dest, int destOffset, TraceContext context) {
        dest[destOffset] = 48;
        dest[destOffset + 1] = Boolean.TRUE.equals(context.sampled()) ? 49 : 48;
    }

    public <R> TraceContext.Extractor<R> extractor(Propagation.Getter<R, String> getter) {
        Objects.requireNonNull(getter, "getter");
        return carrier -> {
            String traceParent = getter.get(carrier, (Object)TRACEPARENT);
            if (traceParent == null) {
                return this.withBaggage(TraceContextOrSamplingFlags.EMPTY, carrier, getter);
            }
            TraceContext contextFromParentHeader = W3CPropagation.extractContextFromTraceParent(traceParent);
            if (contextFromParentHeader == null) {
                return this.withBaggage(TraceContextOrSamplingFlags.EMPTY, carrier, getter);
            }
            String traceStateHeader = getter.get(carrier, (Object)TRACESTATE);
            TraceContextOrSamplingFlags context = this.context(contextFromParentHeader, traceStateHeader);
            if (this.baggagePropagator == null || this.braveBaggageManager == null) {
                return context;
            }
            return this.withBaggage(context, carrier, getter);
        };
    }

    private <R> TraceContextOrSamplingFlags withBaggage(TraceContextOrSamplingFlags context, R carrier, Propagation.Getter<R, String> getter) {
        if (context.context() == null) {
            return context;
        }
        return this.baggagePropagator.contextWithBaggage(carrier, context, getter);
    }

    TraceContextOrSamplingFlags context(TraceContext contextFromParentHeader, String traceStateHeader) {
        if (!StringUtils.isNotBlank((String)traceStateHeader)) {
            return TraceContextOrSamplingFlags.create((TraceContext)contextFromParentHeader);
        }
        try {
            return TraceContextOrSamplingFlags.newBuilder((TraceContext)TraceContext.newBuilder().traceId(contextFromParentHeader.traceId()).traceIdHigh(contextFromParentHeader.traceIdHigh()).spanId(contextFromParentHeader.spanId()).sampled(contextFromParentHeader.sampled()).build()).build();
        }
        catch (IllegalArgumentException e) {
            logger.info("Unparseable tracestate header. Returning span context without state.");
            return TraceContextOrSamplingFlags.create((TraceContext)contextFromParentHeader);
        }
    }

    static {
        for (int i = 0; i < 255; ++i) {
            String version = Long.toHexString(i);
            if (version.length() < 2) {
                version = '0' + version;
            }
            VALID_VERSIONS.add(version);
        }
    }
}

