/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.tck;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.MockClock;
import io.micrometer.core.instrument.distribution.CountAtBucket;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.internal.DefaultLongTaskTimer;
import io.micrometer.core.instrument.simple.SimpleConfig;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

public class DefaultLongTaskTimerTest {
    @Test
    @DisplayName(value="supports sending histograms of active task duration")
    void histogram() {
        SimpleMeterRegistry registry = new SimpleMeterRegistry(SimpleConfig.DEFAULT, (Clock)new MockClock());
        LongTaskTimer t = LongTaskTimer.builder((String)"my.timer").serviceLevelObjectives(new Duration[]{Duration.ofSeconds(10L), Duration.ofSeconds(40L), Duration.ofMinutes(1L)}).register((MeterRegistry)registry);
        List<Integer> samples = Arrays.asList(48, 42, 40, 35, 22, 16, 13, 8, 6, 4, 2);
        int prior = samples.get(0);
        for (Integer value : samples) {
            MockClock.clock((MeterRegistry)registry).add((long)(prior - value), TimeUnit.SECONDS);
            t.start();
            prior = value;
        }
        MockClock.clock((MeterRegistry)registry).add((long)samples.get(samples.size() - 1).intValue(), TimeUnit.SECONDS);
        CountAtBucket[] countAtBuckets = t.takeSnapshot().histogramCounts();
        Assertions.assertThat((double)countAtBuckets[0].bucket(TimeUnit.SECONDS)).isEqualTo(10.0);
        Assertions.assertThat((double)countAtBuckets[0].count()).isEqualTo(4.0);
        Assertions.assertThat((double)countAtBuckets[1].bucket(TimeUnit.SECONDS)).isEqualTo(40.0);
        Assertions.assertThat((double)countAtBuckets[1].count()).isEqualTo(9.0);
        Assertions.assertThat((double)countAtBuckets[2].bucket(TimeUnit.MINUTES)).isEqualTo(1.0);
        Assertions.assertThat((double)countAtBuckets[2].count()).isEqualTo(11.0);
    }

    @Test
    void histogramWithMoreBucketsThanActiveTasks() {
        MockClock clock = new MockClock();
        SimpleMeterRegistry registry = new SimpleMeterRegistry(SimpleConfig.DEFAULT, (Clock)clock){

            protected LongTaskTimer newLongTaskTimer(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig) {
                return new DefaultLongTaskTimer(id, this.clock, this.getBaseTimeUnit(), distributionStatisticConfig, true);
            }
        };
        LongTaskTimer ltt = LongTaskTimer.builder((String)"my.ltt").publishPercentileHistogram().register((MeterRegistry)registry);
        ltt.start();
        clock.add(15L, TimeUnit.MINUTES);
        ltt.start();
        clock.add(5L, TimeUnit.MINUTES);
        CountAtBucket[] countAtBuckets = ltt.takeSnapshot().histogramCounts();
        int index = 0;
        while (countAtBuckets[index].bucket(TimeUnit.NANOSECONDS) < (double)Duration.ofMinutes(5L).toNanos()) {
            Assertions.assertThat((double)countAtBuckets[index++].count()).isZero();
        }
        while (countAtBuckets[index].bucket(TimeUnit.NANOSECONDS) < (double)Duration.ofMinutes(20L).toNanos()) {
            Assertions.assertThat((double)countAtBuckets[index++].count()).isOne();
        }
        while (index < countAtBuckets.length) {
            Assertions.assertThat((double)countAtBuckets[index++].count()).isEqualTo(2.0);
        }
    }
}

