/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.prometheusmetrics;

import io.micrometer.common.lang.Nullable;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.config.NamingConvention;
import io.prometheus.metrics.model.snapshots.PrometheusNaming;

public class PrometheusNamingConvention
implements NamingConvention {
    private final String timerSuffix;

    public PrometheusNamingConvention() {
        this("");
    }

    public PrometheusNamingConvention(String timerSuffix) {
        this.timerSuffix = timerSuffix;
    }

    public String name(String name, Meter.Type type, @Nullable String baseUnit) {
        String conventionName = PrometheusNaming.prometheusName((String)name);
        switch (type) {
            case COUNTER: 
            case DISTRIBUTION_SUMMARY: 
            case GAUGE: {
                if (baseUnit == null || conventionName.endsWith("_" + baseUnit)) break;
                conventionName = conventionName + "_" + baseUnit;
            }
        }
        switch (type) {
            case TIMER: 
            case LONG_TASK_TIMER: {
                if (!this.timerSuffix.isEmpty() && conventionName.endsWith(this.timerSuffix)) {
                    conventionName = conventionName + "_seconds";
                    break;
                }
                if (conventionName.endsWith("_seconds")) break;
                conventionName = conventionName + this.timerSuffix + "_seconds";
            }
        }
        return PrometheusNaming.sanitizeMetricName((String)conventionName);
    }

    public String tagKey(String key) {
        return PrometheusNaming.sanitizeLabelName((String)PrometheusNaming.prometheusName((String)key));
    }
}

