/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.jvm;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.instrument.binder.MeterConvention;
import io.micrometer.core.instrument.binder.jvm.JvmMemory;
import io.micrometer.core.instrument.binder.jvm.convention.JvmMemoryMeterConventions;
import io.micrometer.core.instrument.binder.jvm.convention.micrometer.MicrometerJvmMemoryMeterConventions;
import java.lang.management.BufferPoolMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;

public class JvmMemoryMetrics
implements MeterBinder {
    private final Tags tags;
    private final JvmMemoryMeterConventions conventions;

    public JvmMemoryMetrics() {
        this(Tags.empty(), new MicrometerJvmMemoryMeterConventions());
    }

    public JvmMemoryMetrics(Iterable<Tag> extraTags) {
        this(extraTags, new MicrometerJvmMemoryMeterConventions(Tags.of(extraTags)));
    }

    public JvmMemoryMetrics(Iterable<? extends Tag> extraTags, JvmMemoryMeterConventions conventions) {
        this.tags = Tags.of(extraTags);
        this.conventions = conventions;
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        for (BufferPoolMXBean bufferPoolBean : ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class)) {
            Tags tagsWithId = Tags.concat((Iterable<? extends Tag>)this.tags, "id", bufferPoolBean.getName());
            Gauge.builder("jvm.buffer.count", bufferPoolBean, BufferPoolMXBean::getCount).tags(tagsWithId).description("An estimate of the number of buffers in the pool").baseUnit("buffers").register(registry);
            Gauge.builder("jvm.buffer.memory.used", bufferPoolBean, BufferPoolMXBean::getMemoryUsed).tags(tagsWithId).description("An estimate of the memory that the Java virtual machine is using for this buffer pool").baseUnit("bytes").register(registry);
            Gauge.builder("jvm.buffer.total.capacity", bufferPoolBean, BufferPoolMXBean::getTotalCapacity).tags(tagsWithId).description("An estimate of the total capacity of the buffers in this pool").baseUnit("bytes").register(registry);
        }
        for (MemoryPoolMXBean memoryPoolBean : ManagementFactory.getPlatformMXBeans(MemoryPoolMXBean.class)) {
            MeterConvention<MemoryPoolMXBean> memoryUsedConvention = this.conventions.getMemoryUsedConvention();
            Gauge.builder(memoryUsedConvention.getName(), memoryPoolBean, mem -> JvmMemory.getUsageValue(mem, MemoryUsage::getUsed)).tags(memoryUsedConvention.getTags(memoryPoolBean)).description("The amount of used memory").baseUnit("bytes").register(registry);
            MeterConvention<MemoryPoolMXBean> memoryCommittedConvention = this.conventions.getMemoryCommittedConvention();
            Gauge.builder(memoryCommittedConvention.getName(), memoryPoolBean, mem -> JvmMemory.getUsageValue(mem, MemoryUsage::getCommitted)).tags(memoryCommittedConvention.getTags(memoryPoolBean)).description("The amount of memory in bytes that is committed for the Java virtual machine to use").baseUnit("bytes").register(registry);
            MeterConvention<MemoryPoolMXBean> memoryMaxConvention = this.conventions.getMemoryMaxConvention();
            Gauge.builder(memoryMaxConvention.getName(), memoryPoolBean, mem -> JvmMemory.getUsageValue(mem, MemoryUsage::getMax)).tags(memoryMaxConvention.getTags(memoryPoolBean)).description("The maximum amount of memory in bytes that can be used for memory management").baseUnit("bytes").register(registry);
        }
    }
}

