/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.ExceptionFactory;
import io.lettuce.core.RedisCommandExecutionException;
import io.lettuce.core.RedisCommandInterruptedException;
import io.lettuce.core.RedisCommandTimeoutException;
import io.lettuce.core.RedisException;
import io.lettuce.core.RedisFuture;
import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class LettuceFutures {
    private LettuceFutures() {
    }

    public static boolean awaitAll(Duration timeout, Future<?> ... futures) {
        return LettuceFutures.awaitAll(timeout.toNanos(), TimeUnit.NANOSECONDS, futures);
    }

    public static boolean awaitAll(long timeout, TimeUnit unit, Future<?> ... futures) {
        try {
            long nanos = unit.toNanos(timeout);
            long time = System.nanoTime();
            for (Future<?> f : futures) {
                if (nanos < 0L) {
                    return false;
                }
                f.get(nanos, TimeUnit.NANOSECONDS);
                long now = System.nanoTime();
                nanos -= now - time;
                time = now;
            }
            return true;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (TimeoutException e) {
            return false;
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof RedisCommandExecutionException) {
                throw ExceptionFactory.createExecutionException(e.getCause().getMessage(), e.getCause());
            }
            throw new RedisException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RedisCommandInterruptedException(e);
        }
        catch (Exception e) {
            throw ExceptionFactory.createExecutionException(null, e);
        }
    }

    public static <T> T awaitOrCancel(RedisFuture<T> cmd, long timeout, TimeUnit unit) {
        try {
            if (!cmd.await(timeout, unit)) {
                cmd.cancel(true);
                throw ExceptionFactory.createTimeoutException(Duration.ofNanos(unit.toNanos(timeout)));
            }
            return (T)cmd.get();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof RedisCommandExecutionException) {
                throw ExceptionFactory.createExecutionException(e.getCause().getMessage(), e.getCause());
            }
            if (e.getCause() instanceof RedisCommandTimeoutException) {
                throw new RedisCommandTimeoutException(e.getCause());
            }
            throw new RedisException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RedisCommandInterruptedException(e);
        }
        catch (Exception e) {
            throw ExceptionFactory.createExecutionException(null, e);
        }
    }
}

