/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.informer.cache;

import io.kubernetes.client.common.KubernetesListObject;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.informer.EventType;
import io.kubernetes.client.informer.ListerWatcher;
import io.kubernetes.client.informer.cache.DeltaFIFO;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.util.CallGeneratorParams;
import io.kubernetes.client.util.Watch;
import io.kubernetes.client.util.Watchable;
import java.net.ConnectException;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectorRunnable<ApiType extends KubernetesObject, ApiListType extends KubernetesListObject>
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ReflectorRunnable.class);
    private String lastSyncResourceVersion;
    private Watchable<ApiType> watch;
    private ListerWatcher<ApiType, ApiListType> listerWatcher;
    private DeltaFIFO store;
    private Class<ApiType> apiTypeClass;
    private AtomicBoolean isActive = new AtomicBoolean(true);
    private final BiConsumer<Class<ApiType>, Throwable> exceptionHandler;

    public ReflectorRunnable(Class<ApiType> apiTypeClass, ListerWatcher listerWatcher, DeltaFIFO store) {
        this(apiTypeClass, listerWatcher, store, ReflectorRunnable::defaultWatchErrorHandler);
    }

    public ReflectorRunnable(Class<ApiType> apiTypeClass, ListerWatcher listerWatcher, DeltaFIFO store, BiConsumer<Class<ApiType>, Throwable> exceptionHandler) {
        this.listerWatcher = listerWatcher;
        this.store = store;
        this.apiTypeClass = apiTypeClass;
        this.exceptionHandler = exceptionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        ReflectorRunnable.log.info("{}#Start listing and watching...", this.apiTypeClass);
        try {
            list = this.listerWatcher.list(new CallGeneratorParams(Boolean.FALSE, null, null));
            listMeta = list.getMetadata();
            resourceVersion = listMeta.getResourceVersion();
            items = list.getItems();
            if (ReflectorRunnable.log.isDebugEnabled()) {
                ReflectorRunnable.log.debug("{}#Extract resourceVersion {} list meta", this.apiTypeClass, (Object)resourceVersion);
            }
            this.syncWith(items, resourceVersion);
            this.lastSyncResourceVersion = resourceVersion;
            if (ReflectorRunnable.log.isDebugEnabled()) {
                ReflectorRunnable.log.debug("{}#Start watching with {}...", this.apiTypeClass, (Object)this.lastSyncResourceVersion);
            }
            while (true) lbl-1000:
            // 5 sources

            {
                if (!this.isActive.get() && this.watch != null) {
                    this.watch.close();
                    return;
                }
                try {
                    if (ReflectorRunnable.log.isDebugEnabled()) {
                        ReflectorRunnable.log.debug("{}#Start watch with resource version {}", this.apiTypeClass, (Object)this.lastSyncResourceVersion);
                    }
                    this.watch = this.listerWatcher.watch(new CallGeneratorParams(Boolean.TRUE, this.lastSyncResourceVersion, Long.valueOf(Duration.ofMinutes(5L).toMillis()).intValue()));
                    this.watchHandler(this.watch);
                }
                catch (Throwable t) {
                    if (this.isConnectException(t)) {
                        ReflectorRunnable.log.info("{}#Watch get connect exception, retry watch", this.apiTypeClass);
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException var6_7) {
                            // empty catch block
                        }
                    }
                    if (t instanceof RuntimeException && t.getMessage().contains("IO Exception during hasNext")) {
                        ReflectorRunnable.log.info("{}#Read timeout retry list and watch", this.apiTypeClass);
                        return;
                    }
                    this.exceptionHandler.accept(this.apiTypeClass, t);
                    return;
                }
                finally {
                    if (this.watch == null) continue;
                    this.watch.close();
                    this.watch = null;
                    continue;
                }
                break;
            }
        }
        catch (Throwable t) {
            this.exceptionHandler.accept(this.apiTypeClass, t);
            return;
        }
        ** GOTO lbl-1000
    }

    public void stop() {
        this.isActive.set(false);
    }

    private void syncWith(List<? extends KubernetesObject> items, String resourceVersion) {
        this.store.replace(items, resourceVersion);
    }

    public String getLastSyncResourceVersion() {
        return this.lastSyncResourceVersion;
    }

    private void watchHandler(Watchable<ApiType> watch) {
        while (watch.hasNext()) {
            Watch.Response item = (Watch.Response)watch.next();
            EventType eventType = EventType.getByType(item.type);
            if (eventType == null) {
                log.error("unrecognized event {}", (Object)item);
                continue;
            }
            if (eventType == EventType.ERROR) {
                String errorMessage = String.format("got ERROR event and its status: %s", item.status.toString());
                log.error(errorMessage);
                throw new RuntimeException(errorMessage);
            }
            KubernetesObject obj = (KubernetesObject)item.object;
            V1ObjectMeta meta = obj.getMetadata();
            String newResourceVersion = meta.getResourceVersion();
            switch (eventType) {
                case ADDED: {
                    this.store.add(obj);
                    break;
                }
                case MODIFIED: {
                    this.store.update(obj);
                    break;
                }
                case DELETED: {
                    this.store.delete(obj);
                    break;
                }
            }
            this.lastSyncResourceVersion = newResourceVersion;
            if (!log.isDebugEnabled()) continue;
            log.debug("{}#Receiving resourceVersion {}", this.apiTypeClass, (Object)this.lastSyncResourceVersion);
        }
    }

    private static <ApiType extends KubernetesObject> void defaultWatchErrorHandler(Class<ApiType> watchingApiTypeClass, Throwable t) {
        log.error(String.format("%s#Reflector loop failed unexpectedly", watchingApiTypeClass), t);
    }

    private boolean isConnectException(Throwable t) {
        if (t instanceof ConnectException) {
            return true;
        }
        Throwable cause = t.getCause();
        return cause instanceof ConnectException;
    }
}

