/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1beta2DaemonSetCondition;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="DaemonSetStatus represents the current status of a daemon set.")
public class V1beta2DaemonSetStatus {
    public static final String SERIALIZED_NAME_COLLISION_COUNT = "collisionCount";
    @SerializedName(value="collisionCount")
    private Integer collisionCount;
    public static final String SERIALIZED_NAME_CONDITIONS = "conditions";
    @SerializedName(value="conditions")
    private List<V1beta2DaemonSetCondition> conditions = null;
    public static final String SERIALIZED_NAME_CURRENT_NUMBER_SCHEDULED = "currentNumberScheduled";
    @SerializedName(value="currentNumberScheduled")
    private Integer currentNumberScheduled;
    public static final String SERIALIZED_NAME_DESIRED_NUMBER_SCHEDULED = "desiredNumberScheduled";
    @SerializedName(value="desiredNumberScheduled")
    private Integer desiredNumberScheduled;
    public static final String SERIALIZED_NAME_NUMBER_AVAILABLE = "numberAvailable";
    @SerializedName(value="numberAvailable")
    private Integer numberAvailable;
    public static final String SERIALIZED_NAME_NUMBER_MISSCHEDULED = "numberMisscheduled";
    @SerializedName(value="numberMisscheduled")
    private Integer numberMisscheduled;
    public static final String SERIALIZED_NAME_NUMBER_READY = "numberReady";
    @SerializedName(value="numberReady")
    private Integer numberReady;
    public static final String SERIALIZED_NAME_NUMBER_UNAVAILABLE = "numberUnavailable";
    @SerializedName(value="numberUnavailable")
    private Integer numberUnavailable;
    public static final String SERIALIZED_NAME_OBSERVED_GENERATION = "observedGeneration";
    @SerializedName(value="observedGeneration")
    private Long observedGeneration;
    public static final String SERIALIZED_NAME_UPDATED_NUMBER_SCHEDULED = "updatedNumberScheduled";
    @SerializedName(value="updatedNumberScheduled")
    private Integer updatedNumberScheduled;

    public V1beta2DaemonSetStatus collisionCount(Integer collisionCount) {
        this.collisionCount = collisionCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Count of hash collisions for the DaemonSet. The DaemonSet controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ControllerRevision.")
    public Integer getCollisionCount() {
        return this.collisionCount;
    }

    public void setCollisionCount(Integer collisionCount) {
        this.collisionCount = collisionCount;
    }

    public V1beta2DaemonSetStatus conditions(List<V1beta2DaemonSetCondition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public V1beta2DaemonSetStatus addConditionsItem(V1beta2DaemonSetCondition conditionsItem) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1beta2DaemonSetCondition>();
        }
        this.conditions.add(conditionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Represents the latest available observations of a DaemonSet's current state.")
    public List<V1beta2DaemonSetCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<V1beta2DaemonSetCondition> conditions) {
        this.conditions = conditions;
    }

    public V1beta2DaemonSetStatus currentNumberScheduled(Integer currentNumberScheduled) {
        this.currentNumberScheduled = currentNumberScheduled;
        return this;
    }

    @ApiModelProperty(required=true, value="The number of nodes that are running at least 1 daemon pod and are supposed to run the daemon pod. More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/")
    public Integer getCurrentNumberScheduled() {
        return this.currentNumberScheduled;
    }

    public void setCurrentNumberScheduled(Integer currentNumberScheduled) {
        this.currentNumberScheduled = currentNumberScheduled;
    }

    public V1beta2DaemonSetStatus desiredNumberScheduled(Integer desiredNumberScheduled) {
        this.desiredNumberScheduled = desiredNumberScheduled;
        return this;
    }

    @ApiModelProperty(required=true, value="The total number of nodes that should be running the daemon pod (including nodes correctly running the daemon pod). More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/")
    public Integer getDesiredNumberScheduled() {
        return this.desiredNumberScheduled;
    }

    public void setDesiredNumberScheduled(Integer desiredNumberScheduled) {
        this.desiredNumberScheduled = desiredNumberScheduled;
    }

    public V1beta2DaemonSetStatus numberAvailable(Integer numberAvailable) {
        this.numberAvailable = numberAvailable;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of nodes that should be running the daemon pod and have one or more of the daemon pod running and available (ready for at least spec.minReadySeconds)")
    public Integer getNumberAvailable() {
        return this.numberAvailable;
    }

    public void setNumberAvailable(Integer numberAvailable) {
        this.numberAvailable = numberAvailable;
    }

    public V1beta2DaemonSetStatus numberMisscheduled(Integer numberMisscheduled) {
        this.numberMisscheduled = numberMisscheduled;
        return this;
    }

    @ApiModelProperty(required=true, value="The number of nodes that are running the daemon pod, but are not supposed to run the daemon pod. More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/")
    public Integer getNumberMisscheduled() {
        return this.numberMisscheduled;
    }

    public void setNumberMisscheduled(Integer numberMisscheduled) {
        this.numberMisscheduled = numberMisscheduled;
    }

    public V1beta2DaemonSetStatus numberReady(Integer numberReady) {
        this.numberReady = numberReady;
        return this;
    }

    @ApiModelProperty(required=true, value="The number of nodes that should be running the daemon pod and have one or more of the daemon pod running and ready.")
    public Integer getNumberReady() {
        return this.numberReady;
    }

    public void setNumberReady(Integer numberReady) {
        this.numberReady = numberReady;
    }

    public V1beta2DaemonSetStatus numberUnavailable(Integer numberUnavailable) {
        this.numberUnavailable = numberUnavailable;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of nodes that should be running the daemon pod and have none of the daemon pod running and available (ready for at least spec.minReadySeconds)")
    public Integer getNumberUnavailable() {
        return this.numberUnavailable;
    }

    public void setNumberUnavailable(Integer numberUnavailable) {
        this.numberUnavailable = numberUnavailable;
    }

    public V1beta2DaemonSetStatus observedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The most recent generation observed by the daemon set controller.")
    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public void setObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
    }

    public V1beta2DaemonSetStatus updatedNumberScheduled(Integer updatedNumberScheduled) {
        this.updatedNumberScheduled = updatedNumberScheduled;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total number of nodes that are running updated daemon pod")
    public Integer getUpdatedNumberScheduled() {
        return this.updatedNumberScheduled;
    }

    public void setUpdatedNumberScheduled(Integer updatedNumberScheduled) {
        this.updatedNumberScheduled = updatedNumberScheduled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta2DaemonSetStatus v1beta2DaemonSetStatus = (V1beta2DaemonSetStatus)o;
        return Objects.equals(this.collisionCount, v1beta2DaemonSetStatus.collisionCount) && Objects.equals(this.conditions, v1beta2DaemonSetStatus.conditions) && Objects.equals(this.currentNumberScheduled, v1beta2DaemonSetStatus.currentNumberScheduled) && Objects.equals(this.desiredNumberScheduled, v1beta2DaemonSetStatus.desiredNumberScheduled) && Objects.equals(this.numberAvailable, v1beta2DaemonSetStatus.numberAvailable) && Objects.equals(this.numberMisscheduled, v1beta2DaemonSetStatus.numberMisscheduled) && Objects.equals(this.numberReady, v1beta2DaemonSetStatus.numberReady) && Objects.equals(this.numberUnavailable, v1beta2DaemonSetStatus.numberUnavailable) && Objects.equals(this.observedGeneration, v1beta2DaemonSetStatus.observedGeneration) && Objects.equals(this.updatedNumberScheduled, v1beta2DaemonSetStatus.updatedNumberScheduled);
    }

    public int hashCode() {
        return Objects.hash(this.collisionCount, this.conditions, this.currentNumberScheduled, this.desiredNumberScheduled, this.numberAvailable, this.numberMisscheduled, this.numberReady, this.numberUnavailable, this.observedGeneration, this.updatedNumberScheduled);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta2DaemonSetStatus {\n");
        sb.append("    collisionCount: ").append(this.toIndentedString(this.collisionCount)).append("\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    currentNumberScheduled: ").append(this.toIndentedString(this.currentNumberScheduled)).append("\n");
        sb.append("    desiredNumberScheduled: ").append(this.toIndentedString(this.desiredNumberScheduled)).append("\n");
        sb.append("    numberAvailable: ").append(this.toIndentedString(this.numberAvailable)).append("\n");
        sb.append("    numberMisscheduled: ").append(this.toIndentedString(this.numberMisscheduled)).append("\n");
        sb.append("    numberReady: ").append(this.toIndentedString(this.numberReady)).append("\n");
        sb.append("    numberUnavailable: ").append(this.toIndentedString(this.numberUnavailable)).append("\n");
        sb.append("    observedGeneration: ").append(this.toIndentedString(this.observedGeneration)).append("\n");
        sb.append("    updatedNumberScheduled: ").append(this.toIndentedString(this.updatedNumberScheduled)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

