/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.apis;

import com.google.gson.reflect.TypeToken;
import io.kubernetes.client.custom.V1Patch;
import io.kubernetes.client.openapi.ApiCallback;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.ApiResponse;
import io.kubernetes.client.openapi.Configuration;
import io.kubernetes.client.openapi.Pair;
import io.kubernetes.client.openapi.models.V1APIResourceList;
import io.kubernetes.client.openapi.models.V1DeleteOptions;
import io.kubernetes.client.openapi.models.V1Status;
import io.kubernetes.client.openapi.models.V1alpha1VolumeAttachment;
import io.kubernetes.client.openapi.models.V1alpha1VolumeAttachmentList;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class StorageV1alpha1Api {
    private ApiClient localVarApiClient;

    public StorageV1alpha1Api() {
        this(Configuration.getDefaultApiClient());
    }

    public StorageV1alpha1Api(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call createVolumeAttachmentCall(V1alpha1VolumeAttachment body, String pretty, String dryRun, String fieldManager, ApiCallback _callback) throws ApiException {
        V1alpha1VolumeAttachment localVarPostBody = body;
        String localVarPath = "/apis/storage.k8s.io/v1alpha1/volumeattachments";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createVolumeAttachmentValidateBeforeCall(V1alpha1VolumeAttachment body, String pretty, String dryRun, String fieldManager, ApiCallback _callback) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createVolumeAttachment(Async)");
        }
        Call localVarCall = this.createVolumeAttachmentCall(body, pretty, dryRun, fieldManager, _callback);
        return localVarCall;
    }

    public V1alpha1VolumeAttachment createVolumeAttachment(V1alpha1VolumeAttachment body, String pretty, String dryRun, String fieldManager) throws ApiException {
        ApiResponse<V1alpha1VolumeAttachment> localVarResp = this.createVolumeAttachmentWithHttpInfo(body, pretty, dryRun, fieldManager);
        return localVarResp.getData();
    }

    public ApiResponse<V1alpha1VolumeAttachment> createVolumeAttachmentWithHttpInfo(V1alpha1VolumeAttachment body, String pretty, String dryRun, String fieldManager) throws ApiException {
        Call localVarCall = this.createVolumeAttachmentValidateBeforeCall(body, pretty, dryRun, fieldManager, null);
        Type localVarReturnType = new TypeToken<V1alpha1VolumeAttachment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createVolumeAttachmentAsync(V1alpha1VolumeAttachment body, String pretty, String dryRun, String fieldManager, ApiCallback<V1alpha1VolumeAttachment> _callback) throws ApiException {
        Call localVarCall = this.createVolumeAttachmentValidateBeforeCall(body, pretty, dryRun, fieldManager, _callback);
        Type localVarReturnType = new TypeToken<V1alpha1VolumeAttachment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteCollectionVolumeAttachmentCall(String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, Integer timeoutSeconds, V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        V1DeleteOptions localVarPostBody = body;
        String localVarPath = "/apis/storage.k8s.io/v1alpha1/volumeattachments";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (gracePeriodSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("gracePeriodSeconds", gracePeriodSeconds));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (orphanDependents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orphanDependents", orphanDependents));
        }
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteCollectionVolumeAttachmentValidateBeforeCall(String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, Integer timeoutSeconds, V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.deleteCollectionVolumeAttachmentCall(pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, timeoutSeconds, body, _callback);
        return localVarCall;
    }

    public V1Status deleteCollectionVolumeAttachment(String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, Integer timeoutSeconds, V1DeleteOptions body) throws ApiException {
        ApiResponse<V1Status> localVarResp = this.deleteCollectionVolumeAttachmentWithHttpInfo(pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, timeoutSeconds, body);
        return localVarResp.getData();
    }

    public ApiResponse<V1Status> deleteCollectionVolumeAttachmentWithHttpInfo(String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, Integer timeoutSeconds, V1DeleteOptions body) throws ApiException {
        Call localVarCall = this.deleteCollectionVolumeAttachmentValidateBeforeCall(pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, timeoutSeconds, body, null);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteCollectionVolumeAttachmentAsync(String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, Integer timeoutSeconds, V1DeleteOptions body, ApiCallback<V1Status> _callback) throws ApiException {
        Call localVarCall = this.deleteCollectionVolumeAttachmentValidateBeforeCall(pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, timeoutSeconds, body, _callback);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteVolumeAttachmentCall(String name, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        V1DeleteOptions localVarPostBody = body;
        String localVarPath = "/apis/storage.k8s.io/v1alpha1/volumeattachments/{name}".replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (gracePeriodSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("gracePeriodSeconds", gracePeriodSeconds));
        }
        if (orphanDependents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orphanDependents", orphanDependents));
        }
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteVolumeAttachmentValidateBeforeCall(String name, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteVolumeAttachment(Async)");
        }
        Call localVarCall = this.deleteVolumeAttachmentCall(name, pretty, dryRun, gracePeriodSeconds, orphanDependents, propagationPolicy, body, _callback);
        return localVarCall;
    }

    public V1Status deleteVolumeAttachment(String name, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body) throws ApiException {
        ApiResponse<V1Status> localVarResp = this.deleteVolumeAttachmentWithHttpInfo(name, pretty, dryRun, gracePeriodSeconds, orphanDependents, propagationPolicy, body);
        return localVarResp.getData();
    }

    public ApiResponse<V1Status> deleteVolumeAttachmentWithHttpInfo(String name, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body) throws ApiException {
        Call localVarCall = this.deleteVolumeAttachmentValidateBeforeCall(name, pretty, dryRun, gracePeriodSeconds, orphanDependents, propagationPolicy, body, null);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteVolumeAttachmentAsync(String name, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body, ApiCallback<V1Status> _callback) throws ApiException {
        Call localVarCall = this.deleteVolumeAttachmentValidateBeforeCall(name, pretty, dryRun, gracePeriodSeconds, orphanDependents, propagationPolicy, body, _callback);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAPIResourcesCall(ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/storage.k8s.io/v1alpha1/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAPIResourcesValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getAPIResourcesCall(_callback);
        return localVarCall;
    }

    public V1APIResourceList getAPIResources() throws ApiException {
        ApiResponse<V1APIResourceList> localVarResp = this.getAPIResourcesWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<V1APIResourceList> getAPIResourcesWithHttpInfo() throws ApiException {
        Call localVarCall = this.getAPIResourcesValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<V1APIResourceList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAPIResourcesAsync(ApiCallback<V1APIResourceList> _callback) throws ApiException {
        Call localVarCall = this.getAPIResourcesValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<V1APIResourceList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listVolumeAttachmentCall(String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, Integer timeoutSeconds, Boolean watch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/storage.k8s.io/v1alpha1/volumeattachments";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (allowWatchBookmarks != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("allowWatchBookmarks", allowWatchBookmarks));
        }
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        if (watch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("watch", watch));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listVolumeAttachmentValidateBeforeCall(String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, Integer timeoutSeconds, Boolean watch, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listVolumeAttachmentCall(pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, timeoutSeconds, watch, _callback);
        return localVarCall;
    }

    public V1alpha1VolumeAttachmentList listVolumeAttachment(String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, Integer timeoutSeconds, Boolean watch) throws ApiException {
        ApiResponse<V1alpha1VolumeAttachmentList> localVarResp = this.listVolumeAttachmentWithHttpInfo(pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, timeoutSeconds, watch);
        return localVarResp.getData();
    }

    public ApiResponse<V1alpha1VolumeAttachmentList> listVolumeAttachmentWithHttpInfo(String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, Integer timeoutSeconds, Boolean watch) throws ApiException {
        Call localVarCall = this.listVolumeAttachmentValidateBeforeCall(pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, timeoutSeconds, watch, null);
        Type localVarReturnType = new TypeToken<V1alpha1VolumeAttachmentList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listVolumeAttachmentAsync(String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, Integer timeoutSeconds, Boolean watch, ApiCallback<V1alpha1VolumeAttachmentList> _callback) throws ApiException {
        Call localVarCall = this.listVolumeAttachmentValidateBeforeCall(pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, timeoutSeconds, watch, _callback);
        Type localVarReturnType = new TypeToken<V1alpha1VolumeAttachmentList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchVolumeAttachmentCall(String name, V1Patch body, String pretty, String dryRun, String fieldManager, Boolean force, ApiCallback _callback) throws ApiException {
        V1Patch localVarPostBody = body;
        String localVarPath = "/apis/storage.k8s.io/v1alpha1/volumeattachments/{name}".replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (force != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("force", force));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json-patch+json", "application/merge-patch+json", "application/strategic-merge-patch+json", "application/apply-patch+yaml"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchVolumeAttachmentValidateBeforeCall(String name, V1Patch body, String pretty, String dryRun, String fieldManager, Boolean force, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchVolumeAttachment(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling patchVolumeAttachment(Async)");
        }
        Call localVarCall = this.patchVolumeAttachmentCall(name, body, pretty, dryRun, fieldManager, force, _callback);
        return localVarCall;
    }

    public V1alpha1VolumeAttachment patchVolumeAttachment(String name, V1Patch body, String pretty, String dryRun, String fieldManager, Boolean force) throws ApiException {
        ApiResponse<V1alpha1VolumeAttachment> localVarResp = this.patchVolumeAttachmentWithHttpInfo(name, body, pretty, dryRun, fieldManager, force);
        return localVarResp.getData();
    }

    public ApiResponse<V1alpha1VolumeAttachment> patchVolumeAttachmentWithHttpInfo(String name, V1Patch body, String pretty, String dryRun, String fieldManager, Boolean force) throws ApiException {
        Call localVarCall = this.patchVolumeAttachmentValidateBeforeCall(name, body, pretty, dryRun, fieldManager, force, null);
        Type localVarReturnType = new TypeToken<V1alpha1VolumeAttachment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchVolumeAttachmentAsync(String name, V1Patch body, String pretty, String dryRun, String fieldManager, Boolean force, ApiCallback<V1alpha1VolumeAttachment> _callback) throws ApiException {
        Call localVarCall = this.patchVolumeAttachmentValidateBeforeCall(name, body, pretty, dryRun, fieldManager, force, _callback);
        Type localVarReturnType = new TypeToken<V1alpha1VolumeAttachment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readVolumeAttachmentCall(String name, String pretty, Boolean exact, Boolean export, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/storage.k8s.io/v1alpha1/volumeattachments/{name}".replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (exact != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("exact", exact));
        }
        if (export != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("export", export));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readVolumeAttachmentValidateBeforeCall(String name, String pretty, Boolean exact, Boolean export, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readVolumeAttachment(Async)");
        }
        Call localVarCall = this.readVolumeAttachmentCall(name, pretty, exact, export, _callback);
        return localVarCall;
    }

    public V1alpha1VolumeAttachment readVolumeAttachment(String name, String pretty, Boolean exact, Boolean export) throws ApiException {
        ApiResponse<V1alpha1VolumeAttachment> localVarResp = this.readVolumeAttachmentWithHttpInfo(name, pretty, exact, export);
        return localVarResp.getData();
    }

    public ApiResponse<V1alpha1VolumeAttachment> readVolumeAttachmentWithHttpInfo(String name, String pretty, Boolean exact, Boolean export) throws ApiException {
        Call localVarCall = this.readVolumeAttachmentValidateBeforeCall(name, pretty, exact, export, null);
        Type localVarReturnType = new TypeToken<V1alpha1VolumeAttachment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readVolumeAttachmentAsync(String name, String pretty, Boolean exact, Boolean export, ApiCallback<V1alpha1VolumeAttachment> _callback) throws ApiException {
        Call localVarCall = this.readVolumeAttachmentValidateBeforeCall(name, pretty, exact, export, _callback);
        Type localVarReturnType = new TypeToken<V1alpha1VolumeAttachment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call replaceVolumeAttachmentCall(String name, V1alpha1VolumeAttachment body, String pretty, String dryRun, String fieldManager, ApiCallback _callback) throws ApiException {
        V1alpha1VolumeAttachment localVarPostBody = body;
        String localVarPath = "/apis/storage.k8s.io/v1alpha1/volumeattachments/{name}".replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call replaceVolumeAttachmentValidateBeforeCall(String name, V1alpha1VolumeAttachment body, String pretty, String dryRun, String fieldManager, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling replaceVolumeAttachment(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling replaceVolumeAttachment(Async)");
        }
        Call localVarCall = this.replaceVolumeAttachmentCall(name, body, pretty, dryRun, fieldManager, _callback);
        return localVarCall;
    }

    public V1alpha1VolumeAttachment replaceVolumeAttachment(String name, V1alpha1VolumeAttachment body, String pretty, String dryRun, String fieldManager) throws ApiException {
        ApiResponse<V1alpha1VolumeAttachment> localVarResp = this.replaceVolumeAttachmentWithHttpInfo(name, body, pretty, dryRun, fieldManager);
        return localVarResp.getData();
    }

    public ApiResponse<V1alpha1VolumeAttachment> replaceVolumeAttachmentWithHttpInfo(String name, V1alpha1VolumeAttachment body, String pretty, String dryRun, String fieldManager) throws ApiException {
        Call localVarCall = this.replaceVolumeAttachmentValidateBeforeCall(name, body, pretty, dryRun, fieldManager, null);
        Type localVarReturnType = new TypeToken<V1alpha1VolumeAttachment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call replaceVolumeAttachmentAsync(String name, V1alpha1VolumeAttachment body, String pretty, String dryRun, String fieldManager, ApiCallback<V1alpha1VolumeAttachment> _callback) throws ApiException {
        Call localVarCall = this.replaceVolumeAttachmentValidateBeforeCall(name, body, pretty, dryRun, fieldManager, _callback);
        Type localVarReturnType = new TypeToken<V1alpha1VolumeAttachment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

