package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V2beta2MetricIdentifierBuilder extends V2beta2MetricIdentifierFluentImpl<V2beta2MetricIdentifierBuilder> implements VisitableBuilder<V2beta2MetricIdentifier,V2beta2MetricIdentifierBuilder>{

    V2beta2MetricIdentifierFluent<?> fluent;
    Boolean validationEnabled;

    public V2beta2MetricIdentifierBuilder(){
            this(true);
    }
    public V2beta2MetricIdentifierBuilder(Boolean validationEnabled){
            this(new V2beta2MetricIdentifier(), validationEnabled);
    }
    public V2beta2MetricIdentifierBuilder(V2beta2MetricIdentifierFluent<?> fluent){
            this(fluent, true);
    }
    public V2beta2MetricIdentifierBuilder(V2beta2MetricIdentifierFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V2beta2MetricIdentifier(), validationEnabled);
    }
    public V2beta2MetricIdentifierBuilder(V2beta2MetricIdentifierFluent<?> fluent,V2beta2MetricIdentifier instance){
            this(fluent, instance, true);
    }
    public V2beta2MetricIdentifierBuilder(V2beta2MetricIdentifierFluent<?> fluent,V2beta2MetricIdentifier instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withName(instance.getName());

            fluent.withSelector(instance.getSelector());

            this.validationEnabled = validationEnabled; 
    }
    public V2beta2MetricIdentifierBuilder(V2beta2MetricIdentifier instance){
            this(instance,true);
    }
    public V2beta2MetricIdentifierBuilder(V2beta2MetricIdentifier instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withName(instance.getName());

            this.withSelector(instance.getSelector());

            this.validationEnabled = validationEnabled; 
    }

    public V2beta2MetricIdentifier build(){
            V2beta2MetricIdentifier buildable = new V2beta2MetricIdentifier();
            buildable.setName(fluent.getName());
            buildable.setSelector(fluent.getSelector());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V2beta2MetricIdentifierBuilder that = (V2beta2MetricIdentifierBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
