package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V2beta1CrossVersionObjectReferenceBuilder extends V2beta1CrossVersionObjectReferenceFluentImpl<V2beta1CrossVersionObjectReferenceBuilder> implements VisitableBuilder<V2beta1CrossVersionObjectReference,V2beta1CrossVersionObjectReferenceBuilder>{

    V2beta1CrossVersionObjectReferenceFluent<?> fluent;
    Boolean validationEnabled;

    public V2beta1CrossVersionObjectReferenceBuilder(){
            this(true);
    }
    public V2beta1CrossVersionObjectReferenceBuilder(Boolean validationEnabled){
            this(new V2beta1CrossVersionObjectReference(), validationEnabled);
    }
    public V2beta1CrossVersionObjectReferenceBuilder(V2beta1CrossVersionObjectReferenceFluent<?> fluent){
            this(fluent, true);
    }
    public V2beta1CrossVersionObjectReferenceBuilder(V2beta1CrossVersionObjectReferenceFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V2beta1CrossVersionObjectReference(), validationEnabled);
    }
    public V2beta1CrossVersionObjectReferenceBuilder(V2beta1CrossVersionObjectReferenceFluent<?> fluent,V2beta1CrossVersionObjectReference instance){
            this(fluent, instance, true);
    }
    public V2beta1CrossVersionObjectReferenceBuilder(V2beta1CrossVersionObjectReferenceFluent<?> fluent,V2beta1CrossVersionObjectReference instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withKind(instance.getKind());

            fluent.withName(instance.getName());

            this.validationEnabled = validationEnabled; 
    }
    public V2beta1CrossVersionObjectReferenceBuilder(V2beta1CrossVersionObjectReference instance){
            this(instance,true);
    }
    public V2beta1CrossVersionObjectReferenceBuilder(V2beta1CrossVersionObjectReference instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withKind(instance.getKind());

            this.withName(instance.getName());

            this.validationEnabled = validationEnabled; 
    }

    public V2beta1CrossVersionObjectReference build(){
            V2beta1CrossVersionObjectReference buildable = new V2beta1CrossVersionObjectReference();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setKind(fluent.getKind());
            buildable.setName(fluent.getName());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V2beta1CrossVersionObjectReferenceBuilder that = (V2beta1CrossVersionObjectReferenceBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
