package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;

public class V1beta1EndpointSliceFluentImpl<A extends V1beta1EndpointSliceFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1beta1EndpointSliceFluent<A>{

    private String addressType;
    private String apiVersion;
    private List<V1beta1EndpointBuilder> endpoints;
    private String kind;
    private V1ObjectMetaBuilder metadata;
    private List<V1beta1EndpointPortBuilder> ports;

    public V1beta1EndpointSliceFluentImpl(){
    }
    public V1beta1EndpointSliceFluentImpl(V1beta1EndpointSlice instance){
            this.withAddressType(instance.getAddressType());

            this.withApiVersion(instance.getApiVersion());

            this.withEndpoints(instance.getEndpoints());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.withPorts(instance.getPorts());

    }

    public String getAddressType(){
            return this.addressType;
    }

    public A withAddressType(String addressType){
            this.addressType=addressType; return (A) this;
    }

    public Boolean hasAddressType(){
            return this.addressType != null;
    }

    public A withNewAddressType(String arg1){
            return (A)withAddressType(new String(arg1));
    }

    public A withNewAddressType(StringBuilder arg1){
            return (A)withAddressType(new String(arg1));
    }

    public A withNewAddressType(StringBuffer arg1){
            return (A)withAddressType(new String(arg1));
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A addToEndpoints(int index,V1beta1Endpoint item){
            if (this.endpoints == null) {this.endpoints = new ArrayList<V1beta1EndpointBuilder>();}
            V1beta1EndpointBuilder builder = new V1beta1EndpointBuilder(item);_visitables.get("endpoints").add(index >= 0 ? index : _visitables.get("endpoints").size(), builder);this.endpoints.add(index >= 0 ? index : endpoints.size(), builder); return (A)this;
    }

    public A setToEndpoints(int index,V1beta1Endpoint item){
            if (this.endpoints == null) {this.endpoints = new ArrayList<V1beta1EndpointBuilder>();}
            V1beta1EndpointBuilder builder = new V1beta1EndpointBuilder(item);
            if (index < 0 || index >= _visitables.get("endpoints").size()) { _visitables.get("endpoints").add(builder); } else { _visitables.get("endpoints").set(index, builder);}
            if (index < 0 || index >= endpoints.size()) { endpoints.add(builder); } else { endpoints.set(index, builder);}
             return (A)this;
    }

    public A addToEndpoints(V1beta1Endpoint... items){
            if (this.endpoints == null) {this.endpoints = new ArrayList<V1beta1EndpointBuilder>();}
            for (V1beta1Endpoint item : items) {V1beta1EndpointBuilder builder = new V1beta1EndpointBuilder(item);_visitables.get("endpoints").add(builder);this.endpoints.add(builder);} return (A)this;
    }

    public A addAllToEndpoints(Collection<V1beta1Endpoint> items){
            if (this.endpoints == null) {this.endpoints = new ArrayList<V1beta1EndpointBuilder>();}
            for (V1beta1Endpoint item : items) {V1beta1EndpointBuilder builder = new V1beta1EndpointBuilder(item);_visitables.get("endpoints").add(builder);this.endpoints.add(builder);} return (A)this;
    }

    public A removeFromEndpoints(V1beta1Endpoint... items){
            for (V1beta1Endpoint item : items) {V1beta1EndpointBuilder builder = new V1beta1EndpointBuilder(item);_visitables.get("endpoints").remove(builder);if (this.endpoints != null) {this.endpoints.remove(builder);}} return (A)this;
    }

    public A removeAllFromEndpoints(Collection<V1beta1Endpoint> items){
            for (V1beta1Endpoint item : items) {V1beta1EndpointBuilder builder = new V1beta1EndpointBuilder(item);_visitables.get("endpoints").remove(builder);if (this.endpoints != null) {this.endpoints.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromEndpoints(io.kubernetes.client.fluent.Predicate<V1beta1EndpointBuilder> predicate){
            if (endpoints == null) return (A) this;
            final Iterator<V1beta1EndpointBuilder> each = endpoints.iterator();
            final List visitables = _visitables.get("endpoints");
            while (each.hasNext()) {
              V1beta1EndpointBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildEndpoints instead.
 * @return The buildable object.
 */
@Deprecated public List<V1beta1Endpoint> getEndpoints(){
            return build(endpoints);
    }

    public List<V1beta1Endpoint> buildEndpoints(){
            return build(endpoints);
    }

    public V1beta1Endpoint buildEndpoint(int index){
            return this.endpoints.get(index).build();
    }

    public V1beta1Endpoint buildFirstEndpoint(){
            return this.endpoints.get(0).build();
    }

    public V1beta1Endpoint buildLastEndpoint(){
            return this.endpoints.get(endpoints.size() - 1).build();
    }

    public V1beta1Endpoint buildMatchingEndpoint(io.kubernetes.client.fluent.Predicate<V1beta1EndpointBuilder> predicate){
            for (V1beta1EndpointBuilder item: endpoints) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingEndpoint(io.kubernetes.client.fluent.Predicate<V1beta1EndpointBuilder> predicate){
            for (V1beta1EndpointBuilder item: endpoints) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withEndpoints(List<V1beta1Endpoint> endpoints){
            if (this.endpoints != null) { _visitables.get("endpoints").removeAll(this.endpoints);}
            if (endpoints != null) {this.endpoints = new ArrayList<V1beta1EndpointBuilder>(); for (V1beta1Endpoint item : endpoints){this.addToEndpoints(item);}} else { this.endpoints = null;} return (A) this;
    }

    public A withEndpoints(V1beta1Endpoint... endpoints){
            if (this.endpoints != null) {this.endpoints.clear();}
            if (endpoints != null) {for (V1beta1Endpoint item :endpoints){ this.addToEndpoints(item);}} return (A) this;
    }

    public Boolean hasEndpoints(){
            return endpoints != null && !endpoints.isEmpty();
    }

    public V1beta1EndpointSliceFluent.EndpointsNested<A> addNewEndpoint(){
            return new EndpointsNestedImpl();
    }

    public V1beta1EndpointSliceFluent.EndpointsNested<A> addNewEndpointLike(V1beta1Endpoint item){
            return new EndpointsNestedImpl(-1, item);
    }

    public V1beta1EndpointSliceFluent.EndpointsNested<A> setNewEndpointLike(int index,V1beta1Endpoint item){
            return new EndpointsNestedImpl(index, item);
    }

    public V1beta1EndpointSliceFluent.EndpointsNested<A> editEndpoint(int index){
            if (endpoints.size() <= index) throw new RuntimeException("Can't edit endpoints. Index exceeds size.");
            return setNewEndpointLike(index, buildEndpoint(index));
    }

    public V1beta1EndpointSliceFluent.EndpointsNested<A> editFirstEndpoint(){
            if (endpoints.size() == 0) throw new RuntimeException("Can't edit first endpoints. The list is empty.");
            return setNewEndpointLike(0, buildEndpoint(0));
    }

    public V1beta1EndpointSliceFluent.EndpointsNested<A> editLastEndpoint(){
            int index = endpoints.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last endpoints. The list is empty.");
            return setNewEndpointLike(index, buildEndpoint(index));
    }

    public V1beta1EndpointSliceFluent.EndpointsNested<A> editMatchingEndpoint(io.kubernetes.client.fluent.Predicate<V1beta1EndpointBuilder> predicate){
            int index = -1;
            for (int i=0;i<endpoints.size();i++) { 
            if (predicate.apply(endpoints.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching endpoints. No match found.");
            return setNewEndpointLike(index, buildEndpoint(index));
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    public A withNewKind(String arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1){
            return (A)withKind(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public V1ObjectMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public V1ObjectMeta buildMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(V1ObjectMeta metadata){
            _visitables.get("metadata").remove(this.metadata);
            if (metadata!=null){ this.metadata= new V1ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata(){
            return this.metadata != null;
    }

    public V1beta1EndpointSliceFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public V1beta1EndpointSliceFluent.MetadataNested<A> withNewMetadataLike(V1ObjectMeta item){
            return new MetadataNestedImpl(item);
    }

    public V1beta1EndpointSliceFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public V1beta1EndpointSliceFluent.MetadataNested<A> editOrNewMetadata(){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): new V1ObjectMetaBuilder().build());
    }

    public V1beta1EndpointSliceFluent.MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    public A addToPorts(int index,V1beta1EndpointPort item){
            if (this.ports == null) {this.ports = new ArrayList<V1beta1EndpointPortBuilder>();}
            V1beta1EndpointPortBuilder builder = new V1beta1EndpointPortBuilder(item);_visitables.get("ports").add(index >= 0 ? index : _visitables.get("ports").size(), builder);this.ports.add(index >= 0 ? index : ports.size(), builder); return (A)this;
    }

    public A setToPorts(int index,V1beta1EndpointPort item){
            if (this.ports == null) {this.ports = new ArrayList<V1beta1EndpointPortBuilder>();}
            V1beta1EndpointPortBuilder builder = new V1beta1EndpointPortBuilder(item);
            if (index < 0 || index >= _visitables.get("ports").size()) { _visitables.get("ports").add(builder); } else { _visitables.get("ports").set(index, builder);}
            if (index < 0 || index >= ports.size()) { ports.add(builder); } else { ports.set(index, builder);}
             return (A)this;
    }

    public A addToPorts(V1beta1EndpointPort... items){
            if (this.ports == null) {this.ports = new ArrayList<V1beta1EndpointPortBuilder>();}
            for (V1beta1EndpointPort item : items) {V1beta1EndpointPortBuilder builder = new V1beta1EndpointPortBuilder(item);_visitables.get("ports").add(builder);this.ports.add(builder);} return (A)this;
    }

    public A addAllToPorts(Collection<V1beta1EndpointPort> items){
            if (this.ports == null) {this.ports = new ArrayList<V1beta1EndpointPortBuilder>();}
            for (V1beta1EndpointPort item : items) {V1beta1EndpointPortBuilder builder = new V1beta1EndpointPortBuilder(item);_visitables.get("ports").add(builder);this.ports.add(builder);} return (A)this;
    }

    public A removeFromPorts(V1beta1EndpointPort... items){
            for (V1beta1EndpointPort item : items) {V1beta1EndpointPortBuilder builder = new V1beta1EndpointPortBuilder(item);_visitables.get("ports").remove(builder);if (this.ports != null) {this.ports.remove(builder);}} return (A)this;
    }

    public A removeAllFromPorts(Collection<V1beta1EndpointPort> items){
            for (V1beta1EndpointPort item : items) {V1beta1EndpointPortBuilder builder = new V1beta1EndpointPortBuilder(item);_visitables.get("ports").remove(builder);if (this.ports != null) {this.ports.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromPorts(io.kubernetes.client.fluent.Predicate<V1beta1EndpointPortBuilder> predicate){
            if (ports == null) return (A) this;
            final Iterator<V1beta1EndpointPortBuilder> each = ports.iterator();
            final List visitables = _visitables.get("ports");
            while (each.hasNext()) {
              V1beta1EndpointPortBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildPorts instead.
 * @return The buildable object.
 */
@Deprecated public List<V1beta1EndpointPort> getPorts(){
            return build(ports);
    }

    public List<V1beta1EndpointPort> buildPorts(){
            return build(ports);
    }

    public V1beta1EndpointPort buildPort(int index){
            return this.ports.get(index).build();
    }

    public V1beta1EndpointPort buildFirstPort(){
            return this.ports.get(0).build();
    }

    public V1beta1EndpointPort buildLastPort(){
            return this.ports.get(ports.size() - 1).build();
    }

    public V1beta1EndpointPort buildMatchingPort(io.kubernetes.client.fluent.Predicate<V1beta1EndpointPortBuilder> predicate){
            for (V1beta1EndpointPortBuilder item: ports) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingPort(io.kubernetes.client.fluent.Predicate<V1beta1EndpointPortBuilder> predicate){
            for (V1beta1EndpointPortBuilder item: ports) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withPorts(List<V1beta1EndpointPort> ports){
            if (this.ports != null) { _visitables.get("ports").removeAll(this.ports);}
            if (ports != null) {this.ports = new ArrayList<V1beta1EndpointPortBuilder>(); for (V1beta1EndpointPort item : ports){this.addToPorts(item);}} else { this.ports = null;} return (A) this;
    }

    public A withPorts(V1beta1EndpointPort... ports){
            if (this.ports != null) {this.ports.clear();}
            if (ports != null) {for (V1beta1EndpointPort item :ports){ this.addToPorts(item);}} return (A) this;
    }

    public Boolean hasPorts(){
            return ports != null && !ports.isEmpty();
    }

    public V1beta1EndpointSliceFluent.PortsNested<A> addNewPort(){
            return new PortsNestedImpl();
    }

    public V1beta1EndpointSliceFluent.PortsNested<A> addNewPortLike(V1beta1EndpointPort item){
            return new PortsNestedImpl(-1, item);
    }

    public V1beta1EndpointSliceFluent.PortsNested<A> setNewPortLike(int index,V1beta1EndpointPort item){
            return new PortsNestedImpl(index, item);
    }

    public V1beta1EndpointSliceFluent.PortsNested<A> editPort(int index){
            if (ports.size() <= index) throw new RuntimeException("Can't edit ports. Index exceeds size.");
            return setNewPortLike(index, buildPort(index));
    }

    public V1beta1EndpointSliceFluent.PortsNested<A> editFirstPort(){
            if (ports.size() == 0) throw new RuntimeException("Can't edit first ports. The list is empty.");
            return setNewPortLike(0, buildPort(0));
    }

    public V1beta1EndpointSliceFluent.PortsNested<A> editLastPort(){
            int index = ports.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last ports. The list is empty.");
            return setNewPortLike(index, buildPort(index));
    }

    public V1beta1EndpointSliceFluent.PortsNested<A> editMatchingPort(io.kubernetes.client.fluent.Predicate<V1beta1EndpointPortBuilder> predicate){
            int index = -1;
            for (int i=0;i<ports.size();i++) { 
            if (predicate.apply(ports.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching ports. No match found.");
            return setNewPortLike(index, buildPort(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            V1beta1EndpointSliceFluentImpl that = (V1beta1EndpointSliceFluentImpl) o;
            if (addressType != null ? !addressType.equals(that.addressType) :that.addressType != null) return false;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (endpoints != null ? !endpoints.equals(that.endpoints) :that.endpoints != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            if (ports != null ? !ports.equals(that.ports) :that.ports != null) return false;
            return true;
    }


    public class EndpointsNestedImpl<N> extends V1beta1EndpointFluentImpl<V1beta1EndpointSliceFluent.EndpointsNested<N>> implements V1beta1EndpointSliceFluent.EndpointsNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1beta1EndpointBuilder builder;
        private final int index;
    
            EndpointsNestedImpl(int index,V1beta1Endpoint item){
                    this.index = index;
                    this.builder = new V1beta1EndpointBuilder(this, item);
            }
            EndpointsNestedImpl(){
                    this.index = -1;
                    this.builder = new V1beta1EndpointBuilder(this);
            }
    
    public N and(){
            return (N) V1beta1EndpointSliceFluentImpl.this.setToEndpoints(index,builder.build());
    }
    public N endEndpoint(){
            return and();
    }

}
    public class MetadataNestedImpl<N> extends V1ObjectMetaFluentImpl<V1beta1EndpointSliceFluent.MetadataNested<N>> implements V1beta1EndpointSliceFluent.MetadataNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1ObjectMetaBuilder builder;
    
            MetadataNestedImpl(V1ObjectMeta item){
                    this.builder = new V1ObjectMetaBuilder(this, item);
            }
            MetadataNestedImpl(){
                    this.builder = new V1ObjectMetaBuilder(this);
            }
    
    public N and(){
            return (N) V1beta1EndpointSliceFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}
    public class PortsNestedImpl<N> extends V1beta1EndpointPortFluentImpl<V1beta1EndpointSliceFluent.PortsNested<N>> implements V1beta1EndpointSliceFluent.PortsNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1beta1EndpointPortBuilder builder;
        private final int index;
    
            PortsNestedImpl(int index,V1beta1EndpointPort item){
                    this.index = index;
                    this.builder = new V1beta1EndpointPortBuilder(this, item);
            }
            PortsNestedImpl(){
                    this.index = -1;
                    this.builder = new V1beta1EndpointPortBuilder(this);
            }
    
    public N and(){
            return (N) V1beta1EndpointSliceFluentImpl.this.setToPorts(index,builder.build());
    }
    public N endPort(){
            return and();
    }

}


}
