package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta1EndpointConditionsBuilder extends V1beta1EndpointConditionsFluentImpl<V1beta1EndpointConditionsBuilder> implements VisitableBuilder<V1beta1EndpointConditions,V1beta1EndpointConditionsBuilder>{

    V1beta1EndpointConditionsFluent<?> fluent;
    Boolean validationEnabled;

    public V1beta1EndpointConditionsBuilder(){
            this(true);
    }
    public V1beta1EndpointConditionsBuilder(Boolean validationEnabled){
            this(new V1beta1EndpointConditions(), validationEnabled);
    }
    public V1beta1EndpointConditionsBuilder(V1beta1EndpointConditionsFluent<?> fluent){
            this(fluent, true);
    }
    public V1beta1EndpointConditionsBuilder(V1beta1EndpointConditionsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1beta1EndpointConditions(), validationEnabled);
    }
    public V1beta1EndpointConditionsBuilder(V1beta1EndpointConditionsFluent<?> fluent,V1beta1EndpointConditions instance){
            this(fluent, instance, true);
    }
    public V1beta1EndpointConditionsBuilder(V1beta1EndpointConditionsFluent<?> fluent,V1beta1EndpointConditions instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withReady(instance.getReady());

            this.validationEnabled = validationEnabled; 
    }
    public V1beta1EndpointConditionsBuilder(V1beta1EndpointConditions instance){
            this(instance,true);
    }
    public V1beta1EndpointConditionsBuilder(V1beta1EndpointConditions instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withReady(instance.getReady());

            this.validationEnabled = validationEnabled; 
    }

    public V1beta1EndpointConditions build(){
            V1beta1EndpointConditions buildable = new V1beta1EndpointConditions();
            buildable.setReady(fluent.isReady());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta1EndpointConditionsBuilder that = (V1beta1EndpointConditionsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
