package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta1CertificateSigningRequestStatusBuilder extends V1beta1CertificateSigningRequestStatusFluentImpl<V1beta1CertificateSigningRequestStatusBuilder> implements VisitableBuilder<V1beta1CertificateSigningRequestStatus,V1beta1CertificateSigningRequestStatusBuilder>{

    V1beta1CertificateSigningRequestStatusFluent<?> fluent;
    Boolean validationEnabled;

    public V1beta1CertificateSigningRequestStatusBuilder(){
            this(true);
    }
    public V1beta1CertificateSigningRequestStatusBuilder(Boolean validationEnabled){
            this(new V1beta1CertificateSigningRequestStatus(), validationEnabled);
    }
    public V1beta1CertificateSigningRequestStatusBuilder(V1beta1CertificateSigningRequestStatusFluent<?> fluent){
            this(fluent, true);
    }
    public V1beta1CertificateSigningRequestStatusBuilder(V1beta1CertificateSigningRequestStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1beta1CertificateSigningRequestStatus(), validationEnabled);
    }
    public V1beta1CertificateSigningRequestStatusBuilder(V1beta1CertificateSigningRequestStatusFluent<?> fluent,V1beta1CertificateSigningRequestStatus instance){
            this(fluent, instance, true);
    }
    public V1beta1CertificateSigningRequestStatusBuilder(V1beta1CertificateSigningRequestStatusFluent<?> fluent,V1beta1CertificateSigningRequestStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withCertificate(instance.getCertificate());

            fluent.withConditions(instance.getConditions());

            this.validationEnabled = validationEnabled; 
    }
    public V1beta1CertificateSigningRequestStatusBuilder(V1beta1CertificateSigningRequestStatus instance){
            this(instance,true);
    }
    public V1beta1CertificateSigningRequestStatusBuilder(V1beta1CertificateSigningRequestStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withCertificate(instance.getCertificate());

            this.withConditions(instance.getConditions());

            this.validationEnabled = validationEnabled; 
    }

    public V1beta1CertificateSigningRequestStatus build(){
            V1beta1CertificateSigningRequestStatus buildable = new V1beta1CertificateSigningRequestStatus();
            buildable.setCertificate(fluent.getCertificate());
            buildable.setConditions(fluent.getConditions());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta1CertificateSigningRequestStatusBuilder that = (V1beta1CertificateSigningRequestStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
