package io.kubernetes.client.openapi.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.util.LinkedHashMap;
import java.lang.StringBuffer;
import java.lang.Byte;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public class V1beta1CertificateSigningRequestSpecFluentImpl<A extends V1beta1CertificateSigningRequestSpecFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1beta1CertificateSigningRequestSpecFluent<A>{

    private Map<String,List<String>> extra;
    private List<String> groups;
    private List<Byte> request;
    private String uid;
    private List<String> usages;
    private String username;

    public V1beta1CertificateSigningRequestSpecFluentImpl(){
    }
    public V1beta1CertificateSigningRequestSpecFluentImpl(V1beta1CertificateSigningRequestSpec instance){
            this.withExtra(instance.getExtra());

            this.withGroups(instance.getGroups());

            this.withRequest(instance.getRequest());

            this.withUid(instance.getUid());

            this.withUsages(instance.getUsages());

            this.withUsername(instance.getUsername());

    }

    public A addToExtra(String key,List<String> value){
            if(this.extra == null && key != null && value != null) { this.extra = new LinkedHashMap<String,List<String>>(); }
            if(key != null && value != null) {this.extra.put(key, value);} return (A)this;
    }

    public A addToExtra(Map<String,List<String>> map){
            if(this.extra == null && map != null) { this.extra = new LinkedHashMap<String,List<String>>(); }
            if(map != null) { this.extra.putAll(map);} return (A)this;
    }

    public A removeFromExtra(String key){
            if(this.extra == null) { return (A) this; }
            if(key != null && this.extra != null) {this.extra.remove(key);} return (A)this;
    }

    public A removeFromExtra(Map<String,List<String>> map){
            if(this.extra == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.extra != null){this.extra.remove(key);}}} return (A)this;
    }

    public Map<String,List<String>> getExtra(){
            return this.extra;
    }

    public A withExtra(Map<String,List<String>> extra){
            if (extra == null) { this.extra =  null;} else {this.extra = new LinkedHashMap<String,List<String>>(extra);} return (A) this;
    }

    public Boolean hasExtra(){
            return this.extra != null;
    }

    public A addToGroups(int index,String item){
            if (this.groups == null) {this.groups = new ArrayList<String>();}
            this.groups.add(index, item);
            return (A)this;
    }

    public A setToGroups(int index,String item){
            if (this.groups == null) {this.groups = new ArrayList<String>();}
            this.groups.set(index, item); return (A)this;
    }

    public A addToGroups(String... items){
            if (this.groups == null) {this.groups = new ArrayList<String>();}
            for (String item : items) {this.groups.add(item);} return (A)this;
    }

    public A addAllToGroups(Collection<String> items){
            if (this.groups == null) {this.groups = new ArrayList<String>();}
            for (String item : items) {this.groups.add(item);} return (A)this;
    }

    public A removeFromGroups(String... items){
            for (String item : items) {if (this.groups!= null){ this.groups.remove(item);}} return (A)this;
    }

    public A removeAllFromGroups(Collection<String> items){
            for (String item : items) {if (this.groups!= null){ this.groups.remove(item);}} return (A)this;
    }

    public List<String> getGroups(){
            return this.groups;
    }

    public String getGroup(int index){
            return this.groups.get(index);
    }

    public String getFirstGroup(){
            return this.groups.get(0);
    }

    public String getLastGroup(){
            return this.groups.get(groups.size() - 1);
    }

    public String getMatchingGroup(io.kubernetes.client.fluent.Predicate<String> predicate){
            for (String item: groups) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingGroup(io.kubernetes.client.fluent.Predicate<String> predicate){
            for (String item: groups) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withGroups(List<String> groups){
            if (this.groups != null) { _visitables.get("groups").removeAll(this.groups);}
            if (groups != null) {this.groups = new ArrayList<String>(); for (String item : groups){this.addToGroups(item);}} else { this.groups = null;} return (A) this;
    }

    public A withGroups(String... groups){
            if (this.groups != null) {this.groups.clear();}
            if (groups != null) {for (String item :groups){ this.addToGroups(item);}} return (A) this;
    }

    public Boolean hasGroups(){
            return groups != null && !groups.isEmpty();
    }

    public A addNewGroup(String arg1){
            return (A)addToGroups(new String(arg1));
    }

    public A addNewGroup(StringBuilder arg1){
            return (A)addToGroups(new String(arg1));
    }

    public A addNewGroup(StringBuffer arg1){
            return (A)addToGroups(new String(arg1));
    }

    public A withRequest(byte... request){
            if (this.request != null) {this.request.clear();}
            if (request != null) {for (byte item :request){ this.addToRequest(item);}} return (A) this;
    }

    public byte[] getRequest(){
            //This needs to work with primitives, so we use arrays.
int size = request != null ? request.size() : 0;
byte[] result = new byte[size];
if (size == 0) {
   return result;
}
int index = 0;
for (byte item : request) {
    result[index++]=item;
}
return result;

    }

    public A addToRequest(int index,Byte item){
            if (this.request == null) {this.request = null;}
            this.request.add(index, item);
            return (A)this;
    }

    public A setToRequest(int index,Byte item){
            if (this.request == null) {this.request = null;}
            this.request.set(index, item); return (A)this;
    }

    public A addToRequest(Byte... items){
            if (this.request == null) {this.request = null;}
            for (Byte item : items) {this.request.add(item);} return (A)this;
    }

    public A addAllToRequest(Collection<Byte> items){
            if (this.request == null) {this.request = null;}
            for (Byte item : items) {this.request.add(item);} return (A)this;
    }

    public A removeFromRequest(Byte... items){
            for (Byte item : items) {if (this.request!= null){ this.request.remove(item);}} return (A)this;
    }

    public A removeAllFromRequest(Collection<Byte> items){
            for (Byte item : items) {if (this.request!= null){ this.request.remove(item);}} return (A)this;
    }

    public Boolean hasRequest(){
            return request != null && !request.isEmpty();
    }

    public A addNewRequest(String arg1){
            return (A)addToRequest(new Byte(arg1));
    }

    public A addNewRequest(byte arg1){
            return (A)addToRequest(new Byte(arg1));
    }

    public String getUid(){
            return this.uid;
    }

    public A withUid(String uid){
            this.uid=uid; return (A) this;
    }

    public Boolean hasUid(){
            return this.uid != null;
    }

    public A withNewUid(String arg1){
            return (A)withUid(new String(arg1));
    }

    public A withNewUid(StringBuilder arg1){
            return (A)withUid(new String(arg1));
    }

    public A withNewUid(StringBuffer arg1){
            return (A)withUid(new String(arg1));
    }

    public A addToUsages(int index,String item){
            if (this.usages == null) {this.usages = new ArrayList<String>();}
            this.usages.add(index, item);
            return (A)this;
    }

    public A setToUsages(int index,String item){
            if (this.usages == null) {this.usages = new ArrayList<String>();}
            this.usages.set(index, item); return (A)this;
    }

    public A addToUsages(String... items){
            if (this.usages == null) {this.usages = new ArrayList<String>();}
            for (String item : items) {this.usages.add(item);} return (A)this;
    }

    public A addAllToUsages(Collection<String> items){
            if (this.usages == null) {this.usages = new ArrayList<String>();}
            for (String item : items) {this.usages.add(item);} return (A)this;
    }

    public A removeFromUsages(String... items){
            for (String item : items) {if (this.usages!= null){ this.usages.remove(item);}} return (A)this;
    }

    public A removeAllFromUsages(Collection<String> items){
            for (String item : items) {if (this.usages!= null){ this.usages.remove(item);}} return (A)this;
    }

    public List<String> getUsages(){
            return this.usages;
    }

    public String getUsage(int index){
            return this.usages.get(index);
    }

    public String getFirstUsage(){
            return this.usages.get(0);
    }

    public String getLastUsage(){
            return this.usages.get(usages.size() - 1);
    }

    public String getMatchingUsage(io.kubernetes.client.fluent.Predicate<String> predicate){
            for (String item: usages) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingUsage(io.kubernetes.client.fluent.Predicate<String> predicate){
            for (String item: usages) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withUsages(List<String> usages){
            if (this.usages != null) { _visitables.get("usages").removeAll(this.usages);}
            if (usages != null) {this.usages = new ArrayList<String>(); for (String item : usages){this.addToUsages(item);}} else { this.usages = null;} return (A) this;
    }

    public A withUsages(String... usages){
            if (this.usages != null) {this.usages.clear();}
            if (usages != null) {for (String item :usages){ this.addToUsages(item);}} return (A) this;
    }

    public Boolean hasUsages(){
            return usages != null && !usages.isEmpty();
    }

    public A addNewUsage(String arg1){
            return (A)addToUsages(new String(arg1));
    }

    public A addNewUsage(StringBuilder arg1){
            return (A)addToUsages(new String(arg1));
    }

    public A addNewUsage(StringBuffer arg1){
            return (A)addToUsages(new String(arg1));
    }

    public String getUsername(){
            return this.username;
    }

    public A withUsername(String username){
            this.username=username; return (A) this;
    }

    public Boolean hasUsername(){
            return this.username != null;
    }

    public A withNewUsername(String arg1){
            return (A)withUsername(new String(arg1));
    }

    public A withNewUsername(StringBuilder arg1){
            return (A)withUsername(new String(arg1));
    }

    public A withNewUsername(StringBuffer arg1){
            return (A)withUsername(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            V1beta1CertificateSigningRequestSpecFluentImpl that = (V1beta1CertificateSigningRequestSpecFluentImpl) o;
            if (extra != null ? !extra.equals(that.extra) :that.extra != null) return false;
            if (groups != null ? !groups.equals(that.groups) :that.groups != null) return false;
            if (request != null ? !request.equals(that.request) :that.request != null) return false;
            if (uid != null ? !uid.equals(that.uid) :that.uid != null) return false;
            if (usages != null ? !usages.equals(that.usages) :that.usages != null) return false;
            if (username != null ? !username.equals(that.username) :that.username != null) return false;
            return true;
    }




}
