package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1UserSubjectBuilder extends V1alpha1UserSubjectFluentImpl<V1alpha1UserSubjectBuilder> implements VisitableBuilder<V1alpha1UserSubject,V1alpha1UserSubjectBuilder>{

    V1alpha1UserSubjectFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1UserSubjectBuilder(){
            this(true);
    }
    public V1alpha1UserSubjectBuilder(Boolean validationEnabled){
            this(new V1alpha1UserSubject(), validationEnabled);
    }
    public V1alpha1UserSubjectBuilder(V1alpha1UserSubjectFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1UserSubjectBuilder(V1alpha1UserSubjectFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1UserSubject(), validationEnabled);
    }
    public V1alpha1UserSubjectBuilder(V1alpha1UserSubjectFluent<?> fluent,V1alpha1UserSubject instance){
            this(fluent, instance, true);
    }
    public V1alpha1UserSubjectBuilder(V1alpha1UserSubjectFluent<?> fluent,V1alpha1UserSubject instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withName(instance.getName());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1UserSubjectBuilder(V1alpha1UserSubject instance){
            this(instance,true);
    }
    public V1alpha1UserSubjectBuilder(V1alpha1UserSubject instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withName(instance.getName());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1UserSubject build(){
            V1alpha1UserSubject buildable = new V1alpha1UserSubject();
            buildable.setName(fluent.getName());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1UserSubjectBuilder that = (V1alpha1UserSubjectBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
