package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1QueuingConfigurationBuilder extends V1alpha1QueuingConfigurationFluentImpl<V1alpha1QueuingConfigurationBuilder> implements VisitableBuilder<V1alpha1QueuingConfiguration,V1alpha1QueuingConfigurationBuilder>{

    V1alpha1QueuingConfigurationFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1QueuingConfigurationBuilder(){
            this(true);
    }
    public V1alpha1QueuingConfigurationBuilder(Boolean validationEnabled){
            this(new V1alpha1QueuingConfiguration(), validationEnabled);
    }
    public V1alpha1QueuingConfigurationBuilder(V1alpha1QueuingConfigurationFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1QueuingConfigurationBuilder(V1alpha1QueuingConfigurationFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1QueuingConfiguration(), validationEnabled);
    }
    public V1alpha1QueuingConfigurationBuilder(V1alpha1QueuingConfigurationFluent<?> fluent,V1alpha1QueuingConfiguration instance){
            this(fluent, instance, true);
    }
    public V1alpha1QueuingConfigurationBuilder(V1alpha1QueuingConfigurationFluent<?> fluent,V1alpha1QueuingConfiguration instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withHandSize(instance.getHandSize());

            fluent.withQueueLengthLimit(instance.getQueueLengthLimit());

            fluent.withQueues(instance.getQueues());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1QueuingConfigurationBuilder(V1alpha1QueuingConfiguration instance){
            this(instance,true);
    }
    public V1alpha1QueuingConfigurationBuilder(V1alpha1QueuingConfiguration instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withHandSize(instance.getHandSize());

            this.withQueueLengthLimit(instance.getQueueLengthLimit());

            this.withQueues(instance.getQueues());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1QueuingConfiguration build(){
            V1alpha1QueuingConfiguration buildable = new V1alpha1QueuingConfiguration();
            buildable.setHandSize(fluent.getHandSize());
            buildable.setQueueLengthLimit(fluent.getQueueLengthLimit());
            buildable.setQueues(fluent.getQueues());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1QueuingConfigurationBuilder that = (V1alpha1QueuingConfigurationBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
