package io.kubernetes.client.openapi.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class V1TokenRequestSpecFluentImpl<A extends V1TokenRequestSpecFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1TokenRequestSpecFluent<A>{

    private List<String> audiences;
    private V1BoundObjectReferenceBuilder boundObjectRef;
    private Long expirationSeconds;

    public V1TokenRequestSpecFluentImpl(){
    }
    public V1TokenRequestSpecFluentImpl(V1TokenRequestSpec instance){
            this.withAudiences(instance.getAudiences());

            this.withBoundObjectRef(instance.getBoundObjectRef());

            this.withExpirationSeconds(instance.getExpirationSeconds());

    }

    public A addToAudiences(int index,String item){
            if (this.audiences == null) {this.audiences = new ArrayList<String>();}
            this.audiences.add(index, item);
            return (A)this;
    }

    public A setToAudiences(int index,String item){
            if (this.audiences == null) {this.audiences = new ArrayList<String>();}
            this.audiences.set(index, item); return (A)this;
    }

    public A addToAudiences(String... items){
            if (this.audiences == null) {this.audiences = new ArrayList<String>();}
            for (String item : items) {this.audiences.add(item);} return (A)this;
    }

    public A addAllToAudiences(Collection<String> items){
            if (this.audiences == null) {this.audiences = new ArrayList<String>();}
            for (String item : items) {this.audiences.add(item);} return (A)this;
    }

    public A removeFromAudiences(String... items){
            for (String item : items) {if (this.audiences!= null){ this.audiences.remove(item);}} return (A)this;
    }

    public A removeAllFromAudiences(Collection<String> items){
            for (String item : items) {if (this.audiences!= null){ this.audiences.remove(item);}} return (A)this;
    }

    public List<String> getAudiences(){
            return this.audiences;
    }

    public String getAudience(int index){
            return this.audiences.get(index);
    }

    public String getFirstAudience(){
            return this.audiences.get(0);
    }

    public String getLastAudience(){
            return this.audiences.get(audiences.size() - 1);
    }

    public String getMatchingAudience(io.kubernetes.client.fluent.Predicate<String> predicate){
            for (String item: audiences) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingAudience(io.kubernetes.client.fluent.Predicate<String> predicate){
            for (String item: audiences) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withAudiences(List<String> audiences){
            if (this.audiences != null) { _visitables.get("audiences").removeAll(this.audiences);}
            if (audiences != null) {this.audiences = new ArrayList<String>(); for (String item : audiences){this.addToAudiences(item);}} else { this.audiences = null;} return (A) this;
    }

    public A withAudiences(String... audiences){
            if (this.audiences != null) {this.audiences.clear();}
            if (audiences != null) {for (String item :audiences){ this.addToAudiences(item);}} return (A) this;
    }

    public Boolean hasAudiences(){
            return audiences != null && !audiences.isEmpty();
    }

    public A addNewAudience(String arg1){
            return (A)addToAudiences(new String(arg1));
    }

    public A addNewAudience(StringBuilder arg1){
            return (A)addToAudiences(new String(arg1));
    }

    public A addNewAudience(StringBuffer arg1){
            return (A)addToAudiences(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildBoundObjectRef instead.
 * @return The buildable object.
 */
@Deprecated public V1BoundObjectReference getBoundObjectRef(){
            return this.boundObjectRef!=null?this.boundObjectRef.build():null;
    }

    public V1BoundObjectReference buildBoundObjectRef(){
            return this.boundObjectRef!=null?this.boundObjectRef.build():null;
    }

    public A withBoundObjectRef(V1BoundObjectReference boundObjectRef){
            _visitables.get("boundObjectRef").remove(this.boundObjectRef);
            if (boundObjectRef!=null){ this.boundObjectRef= new V1BoundObjectReferenceBuilder(boundObjectRef); _visitables.get("boundObjectRef").add(this.boundObjectRef);} return (A) this;
    }

    public Boolean hasBoundObjectRef(){
            return this.boundObjectRef != null;
    }

    public V1TokenRequestSpecFluent.BoundObjectRefNested<A> withNewBoundObjectRef(){
            return new BoundObjectRefNestedImpl();
    }

    public V1TokenRequestSpecFluent.BoundObjectRefNested<A> withNewBoundObjectRefLike(V1BoundObjectReference item){
            return new BoundObjectRefNestedImpl(item);
    }

    public V1TokenRequestSpecFluent.BoundObjectRefNested<A> editBoundObjectRef(){
            return withNewBoundObjectRefLike(getBoundObjectRef());
    }

    public V1TokenRequestSpecFluent.BoundObjectRefNested<A> editOrNewBoundObjectRef(){
            return withNewBoundObjectRefLike(getBoundObjectRef() != null ? getBoundObjectRef(): new V1BoundObjectReferenceBuilder().build());
    }

    public V1TokenRequestSpecFluent.BoundObjectRefNested<A> editOrNewBoundObjectRefLike(V1BoundObjectReference item){
            return withNewBoundObjectRefLike(getBoundObjectRef() != null ? getBoundObjectRef(): item);
    }

    public Long getExpirationSeconds(){
            return this.expirationSeconds;
    }

    public A withExpirationSeconds(Long expirationSeconds){
            this.expirationSeconds=expirationSeconds; return (A) this;
    }

    public Boolean hasExpirationSeconds(){
            return this.expirationSeconds != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            V1TokenRequestSpecFluentImpl that = (V1TokenRequestSpecFluentImpl) o;
            if (audiences != null ? !audiences.equals(that.audiences) :that.audiences != null) return false;
            if (boundObjectRef != null ? !boundObjectRef.equals(that.boundObjectRef) :that.boundObjectRef != null) return false;
            if (expirationSeconds != null ? !expirationSeconds.equals(that.expirationSeconds) :that.expirationSeconds != null) return false;
            return true;
    }


    public class BoundObjectRefNestedImpl<N> extends V1BoundObjectReferenceFluentImpl<V1TokenRequestSpecFluent.BoundObjectRefNested<N>> implements V1TokenRequestSpecFluent.BoundObjectRefNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1BoundObjectReferenceBuilder builder;
    
            BoundObjectRefNestedImpl(V1BoundObjectReference item){
                    this.builder = new V1BoundObjectReferenceBuilder(this, item);
            }
            BoundObjectRefNestedImpl(){
                    this.builder = new V1BoundObjectReferenceBuilder(this);
            }
    
    public N and(){
            return (N) V1TokenRequestSpecFluentImpl.this.withBoundObjectRef(builder.build());
    }
    public N endBoundObjectRef(){
            return and();
    }

}


}
