package io.kubernetes.client.openapi.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Fluent;
import io.kubernetes.client.fluent.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Boolean;

public interface V1TokenRequestFluent<A extends V1TokenRequestFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public V1ObjectMeta getMetadata();
    public V1ObjectMeta buildMetadata();
    public A withMetadata(V1ObjectMeta metadata);
    public Boolean hasMetadata();
    public V1TokenRequestFluent.MetadataNested<A> withNewMetadata();
    public V1TokenRequestFluent.MetadataNested<A> withNewMetadataLike(V1ObjectMeta item);
    public V1TokenRequestFluent.MetadataNested<A> editMetadata();
    public V1TokenRequestFluent.MetadataNested<A> editOrNewMetadata();
    public V1TokenRequestFluent.MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public V1TokenRequestSpec getSpec();
    public V1TokenRequestSpec buildSpec();
    public A withSpec(V1TokenRequestSpec spec);
    public Boolean hasSpec();
    public V1TokenRequestFluent.SpecNested<A> withNewSpec();
    public V1TokenRequestFluent.SpecNested<A> withNewSpecLike(V1TokenRequestSpec item);
    public V1TokenRequestFluent.SpecNested<A> editSpec();
    public V1TokenRequestFluent.SpecNested<A> editOrNewSpec();
    public V1TokenRequestFluent.SpecNested<A> editOrNewSpecLike(V1TokenRequestSpec item);
    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public V1TokenRequestStatus getStatus();
    public V1TokenRequestStatus buildStatus();
    public A withStatus(V1TokenRequestStatus status);
    public Boolean hasStatus();
    public V1TokenRequestFluent.StatusNested<A> withNewStatus();
    public V1TokenRequestFluent.StatusNested<A> withNewStatusLike(V1TokenRequestStatus item);
    public V1TokenRequestFluent.StatusNested<A> editStatus();
    public V1TokenRequestFluent.StatusNested<A> editOrNewStatus();
    public V1TokenRequestFluent.StatusNested<A> editOrNewStatusLike(V1TokenRequestStatus item);

    public interface MetadataNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1ObjectMetaFluent<V1TokenRequestFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1TokenRequestSpecFluent<V1TokenRequestFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}
    public interface StatusNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1TokenRequestStatusFluent<V1TokenRequestFluent.StatusNested<N>>{

        
    public N and();    public N endStatus();
}


}
