package io.kubernetes.client.openapi.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class V1StorageOSPersistentVolumeSourceFluentImpl<A extends V1StorageOSPersistentVolumeSourceFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1StorageOSPersistentVolumeSourceFluent<A>{

    private String fsType;
    private Boolean readOnly;
    private V1ObjectReferenceBuilder secretRef;
    private String volumeName;
    private String volumeNamespace;

    public V1StorageOSPersistentVolumeSourceFluentImpl(){
    }
    public V1StorageOSPersistentVolumeSourceFluentImpl(V1StorageOSPersistentVolumeSource instance){
            this.withFsType(instance.getFsType());

            this.withReadOnly(instance.getReadOnly());

            this.withSecretRef(instance.getSecretRef());

            this.withVolumeName(instance.getVolumeName());

            this.withVolumeNamespace(instance.getVolumeNamespace());

    }

    public String getFsType(){
            return this.fsType;
    }

    public A withFsType(String fsType){
            this.fsType=fsType; return (A) this;
    }

    public Boolean hasFsType(){
            return this.fsType != null;
    }

    public A withNewFsType(String arg1){
            return (A)withFsType(new String(arg1));
    }

    public A withNewFsType(StringBuilder arg1){
            return (A)withFsType(new String(arg1));
    }

    public A withNewFsType(StringBuffer arg1){
            return (A)withFsType(new String(arg1));
    }

    public Boolean isReadOnly(){
            return this.readOnly;
    }

    public A withReadOnly(Boolean readOnly){
            this.readOnly=readOnly; return (A) this;
    }

    public Boolean hasReadOnly(){
            return this.readOnly != null;
    }

    public A withNewReadOnly(String arg1){
            return (A)withReadOnly(new Boolean(arg1));
    }

    public A withNewReadOnly(boolean arg1){
            return (A)withReadOnly(new Boolean(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildSecretRef instead.
 * @return The buildable object.
 */
@Deprecated public V1ObjectReference getSecretRef(){
            return this.secretRef!=null?this.secretRef.build():null;
    }

    public V1ObjectReference buildSecretRef(){
            return this.secretRef!=null?this.secretRef.build():null;
    }

    public A withSecretRef(V1ObjectReference secretRef){
            _visitables.get("secretRef").remove(this.secretRef);
            if (secretRef!=null){ this.secretRef= new V1ObjectReferenceBuilder(secretRef); _visitables.get("secretRef").add(this.secretRef);} return (A) this;
    }

    public Boolean hasSecretRef(){
            return this.secretRef != null;
    }

    public V1StorageOSPersistentVolumeSourceFluent.SecretRefNested<A> withNewSecretRef(){
            return new SecretRefNestedImpl();
    }

    public V1StorageOSPersistentVolumeSourceFluent.SecretRefNested<A> withNewSecretRefLike(V1ObjectReference item){
            return new SecretRefNestedImpl(item);
    }

    public V1StorageOSPersistentVolumeSourceFluent.SecretRefNested<A> editSecretRef(){
            return withNewSecretRefLike(getSecretRef());
    }

    public V1StorageOSPersistentVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRef(){
            return withNewSecretRefLike(getSecretRef() != null ? getSecretRef(): new V1ObjectReferenceBuilder().build());
    }

    public V1StorageOSPersistentVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRefLike(V1ObjectReference item){
            return withNewSecretRefLike(getSecretRef() != null ? getSecretRef(): item);
    }

    public String getVolumeName(){
            return this.volumeName;
    }

    public A withVolumeName(String volumeName){
            this.volumeName=volumeName; return (A) this;
    }

    public Boolean hasVolumeName(){
            return this.volumeName != null;
    }

    public A withNewVolumeName(String arg1){
            return (A)withVolumeName(new String(arg1));
    }

    public A withNewVolumeName(StringBuilder arg1){
            return (A)withVolumeName(new String(arg1));
    }

    public A withNewVolumeName(StringBuffer arg1){
            return (A)withVolumeName(new String(arg1));
    }

    public String getVolumeNamespace(){
            return this.volumeNamespace;
    }

    public A withVolumeNamespace(String volumeNamespace){
            this.volumeNamespace=volumeNamespace; return (A) this;
    }

    public Boolean hasVolumeNamespace(){
            return this.volumeNamespace != null;
    }

    public A withNewVolumeNamespace(String arg1){
            return (A)withVolumeNamespace(new String(arg1));
    }

    public A withNewVolumeNamespace(StringBuilder arg1){
            return (A)withVolumeNamespace(new String(arg1));
    }

    public A withNewVolumeNamespace(StringBuffer arg1){
            return (A)withVolumeNamespace(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            V1StorageOSPersistentVolumeSourceFluentImpl that = (V1StorageOSPersistentVolumeSourceFluentImpl) o;
            if (fsType != null ? !fsType.equals(that.fsType) :that.fsType != null) return false;
            if (readOnly != null ? !readOnly.equals(that.readOnly) :that.readOnly != null) return false;
            if (secretRef != null ? !secretRef.equals(that.secretRef) :that.secretRef != null) return false;
            if (volumeName != null ? !volumeName.equals(that.volumeName) :that.volumeName != null) return false;
            if (volumeNamespace != null ? !volumeNamespace.equals(that.volumeNamespace) :that.volumeNamespace != null) return false;
            return true;
    }


    public class SecretRefNestedImpl<N> extends V1ObjectReferenceFluentImpl<V1StorageOSPersistentVolumeSourceFluent.SecretRefNested<N>> implements V1StorageOSPersistentVolumeSourceFluent.SecretRefNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1ObjectReferenceBuilder builder;
    
            SecretRefNestedImpl(V1ObjectReference item){
                    this.builder = new V1ObjectReferenceBuilder(this, item);
            }
            SecretRefNestedImpl(){
                    this.builder = new V1ObjectReferenceBuilder(this);
            }
    
    public N and(){
            return (N) V1StorageOSPersistentVolumeSourceFluentImpl.this.withSecretRef(builder.build());
    }
    public N endSecretRef(){
            return and();
    }

}


}
