package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1ServiceBuilder extends V1ServiceFluentImpl<V1ServiceBuilder> implements VisitableBuilder<V1Service,V1ServiceBuilder>{

    V1ServiceFluent<?> fluent;
    Boolean validationEnabled;

    public V1ServiceBuilder(){
            this(true);
    }
    public V1ServiceBuilder(Boolean validationEnabled){
            this(new V1Service(), validationEnabled);
    }
    public V1ServiceBuilder(V1ServiceFluent<?> fluent){
            this(fluent, true);
    }
    public V1ServiceBuilder(V1ServiceFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1Service(), validationEnabled);
    }
    public V1ServiceBuilder(V1ServiceFluent<?> fluent,V1Service instance){
            this(fluent, instance, true);
    }
    public V1ServiceBuilder(V1ServiceFluent<?> fluent,V1Service instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withKind(instance.getKind());

            fluent.withMetadata(instance.getMetadata());

            fluent.withSpec(instance.getSpec());

            fluent.withStatus(instance.getStatus());

            this.validationEnabled = validationEnabled; 
    }
    public V1ServiceBuilder(V1Service instance){
            this(instance,true);
    }
    public V1ServiceBuilder(V1Service instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.withSpec(instance.getSpec());

            this.withStatus(instance.getStatus());

            this.validationEnabled = validationEnabled; 
    }

    public V1Service build(){
            V1Service buildable = new V1Service();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setKind(fluent.getKind());
            buildable.setMetadata(fluent.getMetadata());
            buildable.setSpec(fluent.getSpec());
            buildable.setStatus(fluent.getStatus());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1ServiceBuilder that = (V1ServiceBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
