package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1ServiceAccountTokenProjectionBuilder extends V1ServiceAccountTokenProjectionFluentImpl<V1ServiceAccountTokenProjectionBuilder> implements VisitableBuilder<V1ServiceAccountTokenProjection,V1ServiceAccountTokenProjectionBuilder>{

    V1ServiceAccountTokenProjectionFluent<?> fluent;
    Boolean validationEnabled;

    public V1ServiceAccountTokenProjectionBuilder(){
            this(true);
    }
    public V1ServiceAccountTokenProjectionBuilder(Boolean validationEnabled){
            this(new V1ServiceAccountTokenProjection(), validationEnabled);
    }
    public V1ServiceAccountTokenProjectionBuilder(V1ServiceAccountTokenProjectionFluent<?> fluent){
            this(fluent, true);
    }
    public V1ServiceAccountTokenProjectionBuilder(V1ServiceAccountTokenProjectionFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1ServiceAccountTokenProjection(), validationEnabled);
    }
    public V1ServiceAccountTokenProjectionBuilder(V1ServiceAccountTokenProjectionFluent<?> fluent,V1ServiceAccountTokenProjection instance){
            this(fluent, instance, true);
    }
    public V1ServiceAccountTokenProjectionBuilder(V1ServiceAccountTokenProjectionFluent<?> fluent,V1ServiceAccountTokenProjection instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAudience(instance.getAudience());

            fluent.withExpirationSeconds(instance.getExpirationSeconds());

            fluent.withPath(instance.getPath());

            this.validationEnabled = validationEnabled; 
    }
    public V1ServiceAccountTokenProjectionBuilder(V1ServiceAccountTokenProjection instance){
            this(instance,true);
    }
    public V1ServiceAccountTokenProjectionBuilder(V1ServiceAccountTokenProjection instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAudience(instance.getAudience());

            this.withExpirationSeconds(instance.getExpirationSeconds());

            this.withPath(instance.getPath());

            this.validationEnabled = validationEnabled; 
    }

    public V1ServiceAccountTokenProjection build(){
            V1ServiceAccountTokenProjection buildable = new V1ServiceAccountTokenProjection();
            buildable.setAudience(fluent.getAudience());
            buildable.setExpirationSeconds(fluent.getExpirationSeconds());
            buildable.setPath(fluent.getPath());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1ServiceAccountTokenProjectionBuilder that = (V1ServiceAccountTokenProjectionBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
