package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1SelfSubjectAccessReviewSpecBuilder extends V1SelfSubjectAccessReviewSpecFluentImpl<V1SelfSubjectAccessReviewSpecBuilder> implements VisitableBuilder<V1SelfSubjectAccessReviewSpec,V1SelfSubjectAccessReviewSpecBuilder>{

    V1SelfSubjectAccessReviewSpecFluent<?> fluent;
    Boolean validationEnabled;

    public V1SelfSubjectAccessReviewSpecBuilder(){
            this(true);
    }
    public V1SelfSubjectAccessReviewSpecBuilder(Boolean validationEnabled){
            this(new V1SelfSubjectAccessReviewSpec(), validationEnabled);
    }
    public V1SelfSubjectAccessReviewSpecBuilder(V1SelfSubjectAccessReviewSpecFluent<?> fluent){
            this(fluent, true);
    }
    public V1SelfSubjectAccessReviewSpecBuilder(V1SelfSubjectAccessReviewSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1SelfSubjectAccessReviewSpec(), validationEnabled);
    }
    public V1SelfSubjectAccessReviewSpecBuilder(V1SelfSubjectAccessReviewSpecFluent<?> fluent,V1SelfSubjectAccessReviewSpec instance){
            this(fluent, instance, true);
    }
    public V1SelfSubjectAccessReviewSpecBuilder(V1SelfSubjectAccessReviewSpecFluent<?> fluent,V1SelfSubjectAccessReviewSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withNonResourceAttributes(instance.getNonResourceAttributes());

            fluent.withResourceAttributes(instance.getResourceAttributes());

            this.validationEnabled = validationEnabled; 
    }
    public V1SelfSubjectAccessReviewSpecBuilder(V1SelfSubjectAccessReviewSpec instance){
            this(instance,true);
    }
    public V1SelfSubjectAccessReviewSpecBuilder(V1SelfSubjectAccessReviewSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withNonResourceAttributes(instance.getNonResourceAttributes());

            this.withResourceAttributes(instance.getResourceAttributes());

            this.validationEnabled = validationEnabled; 
    }

    public V1SelfSubjectAccessReviewSpec build(){
            V1SelfSubjectAccessReviewSpec buildable = new V1SelfSubjectAccessReviewSpec();
            buildable.setNonResourceAttributes(fluent.getNonResourceAttributes());
            buildable.setResourceAttributes(fluent.getResourceAttributes());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1SelfSubjectAccessReviewSpecBuilder that = (V1SelfSubjectAccessReviewSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
